/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.validation;

import eu.europa.esig.dss.ASiCContainerType;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUnsupportedOperationException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.asic.ASiCExtractResult;
import eu.europa.esig.dss.asic.ASiCUtils;
import eu.europa.esig.dss.asic.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.ValidationContext;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractASiCContainerValidator
extends SignedDocumentValidator {
    protected List<DocumentValidator> validators;
    private ASiCExtractResult extractResult;
    private ASiCContainerType containerType;

    private AbstractASiCContainerValidator() {
        super(null);
        this.document = null;
    }

    protected AbstractASiCContainerValidator(DSSDocument document) {
        super(null);
        this.document = document;
    }

    protected void analyseEntries() {
        AbstractASiCContainerExtractor extractor = this.getArchiveExtractor();
        this.extractResult = extractor.extract();
        this.containerType = ASiCUtils.getContainerType(this.document, this.extractResult.getMimeTypeDocument(), this.extractResult.getZipComment(), this.extractResult.getSignedDocuments());
    }

    abstract AbstractASiCContainerExtractor getArchiveExtractor();

    public ASiCContainerType getContainerType() {
        return this.containerType;
    }

    public List<AdvancedSignature> processSignaturesValidation(ValidationContext validationContext, boolean structuralValidation) {
        ArrayList<AdvancedSignature> allSignatures = new ArrayList<AdvancedSignature>();
        List<DocumentValidator> currentValidators = this.getValidators();
        for (DocumentValidator documentValidator : currentValidators) {
            allSignatures.addAll(documentValidator.processSignaturesValidation(validationContext, structuralValidation));
        }
        this.attachExternalTimestamps(allSignatures);
        return allSignatures;
    }

    protected void attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
    }

    protected ContainerInfo getContainerInfo() {
        ContainerInfo containerInfo = new ContainerInfo();
        containerInfo.setContainerType(this.containerType);
        containerInfo.setZipComment(this.extractResult.getZipComment());
        DSSDocument mimeTypeDocument = this.extractResult.getMimeTypeDocument();
        if (mimeTypeDocument != null) {
            String mimeTypeContent = new String(DSSUtils.toByteArray((DSSDocument)mimeTypeDocument));
            containerInfo.setMimeTypeFilePresent(true);
            containerInfo.setMimeTypeContent(mimeTypeContent);
        } else {
            containerInfo.setMimeTypeFilePresent(false);
        }
        List<DSSDocument> signedDocuments = this.extractResult.getSignedDocuments();
        if (Utils.isCollectionNotEmpty(signedDocuments)) {
            ArrayList<String> signedDocumentFilenames = new ArrayList<String>();
            for (DSSDocument dssDocument : signedDocuments) {
                signedDocumentFilenames.add(dssDocument.getName());
            }
            containerInfo.setSignedDocumentFilenames(signedDocumentFilenames);
        }
        containerInfo.setManifestFiles(this.getManifestFilesDecriptions());
        return containerInfo;
    }

    protected abstract List<ManifestFile> getManifestFilesDecriptions();

    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> allSignatures = new ArrayList<AdvancedSignature>();
        List<DocumentValidator> currentValidators = this.getValidators();
        for (DocumentValidator documentValidator : currentValidators) {
            allSignatures.addAll(documentValidator.getSignatures());
        }
        return allSignatures;
    }

    abstract List<DocumentValidator> getValidators();

    protected List<DSSDocument> getSignatureDocuments() {
        return this.extractResult.getSignatureDocuments();
    }

    protected List<DSSDocument> getSignedDocuments() {
        return this.extractResult.getSignedDocuments();
    }

    protected List<DSSDocument> getManifestDocuments() {
        return this.extractResult.getManifestDocuments();
    }

    protected List<DSSDocument> getTimestampDocuments() {
        return this.extractResult.getTimestampDocuments();
    }

    protected List<DSSDocument> getArchiveManifestDocuments() {
        return this.extractResult.getArchiveManifestDocuments();
    }

    public List<DSSDocument> getOriginalDocuments(String signatureId) throws DSSException {
        throw new DSSUnsupportedOperationException("This method is not applicable for this kind of file!");
    }
}

