/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.definition;

import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;

public enum ASiCElement implements DSSElement
{
    XADES_SIGNATURES("XAdESSignatures"),
    ASIC_MANIFEST("ASiCManifest"),
    SIG_REFERENCE("SigReference"),
    EXTENSION("Extension"),
    DATA_OBJECT_REFERENCE("DataObjectReference"),
    ASIC_MANIFEST_EXTENSIONS("ASiCManifestExtensions"),
    DATA_OBJECT_REFERENCE_EXTENSIONS("DataObjectReferenceExtensions");

    private final DSSNamespace namespace;
    private final String tagName;

    private ASiCElement(String tagName) {
        this.tagName = tagName;
        this.namespace = ASiCNamespace.NS;
    }

    public DSSNamespace getNamespace() {
        return this.namespace;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getURI() {
        return this.namespace.getUri();
    }

    public boolean isSameTagName(String value) {
        return this.tagName.equals(value);
    }
}

