/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CMSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CMSUtils.class);

    private CMSUtils() {
    }

    public static byte[] getEncoded(CMSSignedData data) throws DSSException {
        try {
            return data.getEncoded();
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static CMSSignedData generateCMSSignedData(CMSSignedDataGenerator generator, CMSProcessableByteArray content, boolean encapsulate) throws DSSException {
        try {
            CMSSignedData cmsSignedData = generator.generate((CMSTypedData)content, encapsulate);
            return cmsSignedData;
        }
        catch (CMSException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static CMSSignedData generateDetachedCMSSignedData(CMSSignedDataGenerator generator, CMSProcessableByteArray content) throws DSSException {
        return CMSUtils.generateCMSSignedData(generator, content, false);
    }

    public static DERTaggedObject getDERSignedAttributes(SignerInformation signerInformation) throws DSSException {
        try {
            byte[] encodedSignedAttributes = signerInformation.getEncodedSignedAttributes();
            if (encodedSignedAttributes == null) {
                return null;
            }
            ASN1Set asn1Set = (ASN1Set)DSSASN1Utils.toASN1Primitive((byte[])encodedSignedAttributes);
            return new DERTaggedObject(false, 0, (ASN1Encodable)asn1Set);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getSignedContent(CMSTypedData cmsTypedData) {
        if (cmsTypedData == null) {
            throw new DSSException("CMSTypedData is null (should be a detached signature)");
        }
        try (ByteArrayOutputStream originalDocumentData = new ByteArrayOutputStream();){
            cmsTypedData.write((OutputStream)originalDocumentData);
            byte[] byArray = originalDocumentData.toByteArray();
            return byArray;
        }
        catch (IOException | CMSException e) {
            throw new DSSException(e);
        }
    }

    public static AttributeTable getUnsignedAttributes(SignerInformation signerInformation) {
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return new AttributeTable(new Hashtable());
        }
        return unsignedAttributes;
    }

    public static AttributeTable getSignedAttributes(SignerInformation signerInformation) {
        AttributeTable signedAttributes = signerInformation.getSignedAttributes();
        if (signedAttributes == null) {
            return new AttributeTable(new Hashtable());
        }
        return signedAttributes;
    }

    public static BasicOCSPResp getBasicOcspResp(DERSequence derSequence) {
        BasicOCSPResp basicOCSPResp = null;
        try {
            BasicOCSPResponse basicOcspResponse = BasicOCSPResponse.getInstance((Object)derSequence);
            basicOCSPResp = new BasicOCSPResp(basicOcspResponse);
        }
        catch (Exception e) {
            LOG.error("Impossible to create BasicOCSPResp from DERSequence!", (Throwable)e);
        }
        return basicOCSPResp;
    }

    public static OCSPResp getOcspResp(DERSequence derSequence) {
        OCSPResp ocspResp = null;
        try {
            OCSPResponse ocspResponse = OCSPResponse.getInstance((Object)derSequence);
            ocspResp = new OCSPResp(ocspResponse);
        }
        catch (Exception e) {
            LOG.error("Impossible to create OCSPResp from DERSequence!", (Throwable)e);
        }
        return ocspResp;
    }

    public static BasicOCSPResp getBasicOCSPResp(OCSPResp ocspResp) {
        BasicOCSPResp basicOCSPResp = null;
        try {
            Object responseObject = ocspResp.getResponseObject();
            if (responseObject instanceof BasicOCSPResp) {
                basicOCSPResp = (BasicOCSPResp)responseObject;
            } else {
                LOG.warn("Unknown OCSP response type: {}", responseObject.getClass());
            }
        }
        catch (OCSPException e) {
            LOG.error("Impossible to process OCSPResp!", (Throwable)e);
        }
        return basicOCSPResp;
    }
}

