/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class CMSDocumentValidator
extends SignedDocumentValidator {
    protected CMSSignedData cmsSignedData;

    public CMSDocumentValidator() {
        super((SignatureScopeFinder)new CAdESSignatureScopeFinder());
    }

    public CMSDocumentValidator(CMSSignedData cmsSignedData) {
        this();
        this.cmsSignedData = cmsSignedData;
    }

    public CMSDocumentValidator(DSSDocument document) throws DSSException {
        this();
        this.document = document;
        try (InputStream inputStream = document.openStream();){
            this.cmsSignedData = new CMSSignedData(inputStream);
        }
        catch (IOException | CMSException e) {
            throw new DSSException("Not a valid CAdES file", e);
        }
    }

    public boolean isSupported(DSSDocument dssDocument) {
        byte firstByte = DSSUtils.readFirstByte((DSSDocument)dssDocument);
        return DSSASN1Utils.isASN1SequenceTag((byte)firstByte);
    }

    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> signatures = new ArrayList<AdvancedSignature>();
        if (this.cmsSignedData != null) {
            for (Object signerInformationObject : this.cmsSignedData.getSignerInfos().getSigners()) {
                SignerInformation signerInformation = (SignerInformation)signerInformationObject;
                CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation, this.validationCertPool);
                if (this.document != null) {
                    cadesSignature.setSignatureFilename(this.document.getName());
                }
                cadesSignature.setDetachedContents(this.detachedContents);
                cadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
                signatures.add((AdvancedSignature)cadesSignature);
            }
        }
        return signatures;
    }

    public List<DSSDocument> getOriginalDocuments(String signatureId) throws DSSException {
        if (Utils.isStringBlank((String)signatureId)) {
            throw new NullPointerException("signatureId");
        }
        ArrayList<DSSDocument> results = new ArrayList<DSSDocument>();
        for (Object signerInformationObject : this.cmsSignedData.getSignerInfos().getSigners()) {
            SignerInformation signerInformation = (SignerInformation)signerInformationObject;
            CAdESSignature cadesSignature = new CAdESSignature(this.cmsSignedData, signerInformation, this.validationCertPool);
            cadesSignature.setSignatureFilename(this.document.getName());
            cadesSignature.setDetachedContents(this.detachedContents);
            cadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
            if (!Utils.areStringsEqual((String)cadesSignature.getId(), (String)signatureId)) continue;
            results.add((DSSDocument)new InMemoryDocument(cadesSignature.getOriginalDocumentStream()));
        }
        return results;
    }
}

