/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.crl.AbstractCRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.crl.ICRLUtils;
import eu.europa.esig.dss.crl.X509CRLValidity;
import eu.europa.esig.dss.tsl.KeyUsageBit;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLUtilsX509CRLImpl
extends AbstractCRLUtils
implements ICRLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CRLUtilsX509CRLImpl.class);
    private static final BouncyCastleProvider BC_PROVIDER = new BouncyCastleProvider();
    private static final CertificateFactory CERT_FACTORY;

    public CRLValidity isValidCRL(InputStream crlStream, CertificateToken issuerToken) {
        X509CRLValidity crlValidity = new X509CRLValidity();
        X509CRL x509CRL = this.loadCRL(crlStream);
        try {
            crlValidity.setX509CRL(x509CRL);
            crlValidity.setCrlEncoded(x509CRL.getEncoded());
        }
        catch (CRLException e) {
            LOG.error("Unable to read the CRL binaries", (Throwable)e);
        }
        String sigAlgOID = x509CRL.getSigAlgOID();
        crlValidity.setSignatureAlgorithm(SignatureAlgorithm.forOID((String)sigAlgOID));
        crlValidity.setThisUpdate(x509CRL.getThisUpdate());
        crlValidity.setNextUpdate(x509CRL.getNextUpdate());
        X500Principal x509CRLIssuerX500Principal = x509CRL.getIssuerX500Principal();
        X500Principal issuerTokenSubjectX500Principal = issuerToken.getSubjectX500Principal();
        if (x509CRLIssuerX500Principal.equals(issuerTokenSubjectX500Principal)) {
            crlValidity.setIssuerX509PrincipalMatches(true);
        }
        this.checkCriticalExtensions(crlValidity, x509CRL.getCriticalExtensionOIDs(), x509CRL.getExtensionValue(Extension.issuingDistributionPoint.getId()));
        this.extractExpiredCertsOnCRL(crlValidity, x509CRL.getExtensionValue(Extension.expiredCertsOnCRL.getId()));
        this.checkSignatureValue(x509CRL, issuerToken, crlValidity);
        if (crlValidity.isSignatureIntact()) {
            crlValidity.setCrlSignKeyUsage(issuerToken.checkKeyUsage(KeyUsageBit.crlSign));
        }
        return crlValidity;
    }

    private void checkSignatureValue(X509CRL x509CRL, CertificateToken issuerToken, CRLValidity crlValidity) {
        try {
            x509CRL.verify(issuerToken.getPublicKey());
            crlValidity.setSignatureIntact(true);
            crlValidity.setIssuerToken(issuerToken);
        }
        catch (KeyException | NoSuchAlgorithmException | SignatureException | CRLException e) {
            crlValidity.setSignatureInvalidityReason(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public X509CRLEntry getRevocationInfo(CRLValidity crlValidity, BigInteger serialNumber) {
        X509CRL crl = this.getCRL(crlValidity);
        return crl.getRevokedCertificate(serialNumber);
    }

    private X509CRL getCRL(CRLValidity crlValidity) {
        X509CRL crl = null;
        if (crlValidity instanceof X509CRLValidity) {
            X509CRLValidity x509Validity = (X509CRLValidity)crlValidity;
            crl = x509Validity.getX509CRL();
        }
        if (crl == null) {
            crl = this.loadCRL(crlValidity.getCrlInputStream());
        }
        return crl;
    }

    private X509CRL loadCRL(InputStream inputStream) {
        try {
            X509CRL crl = (X509CRL)CERT_FACTORY.generateCRL(inputStream);
            if (crl == null) {
                throw new DSSException("Unable to parse the CRL");
            }
            return crl;
        }
        catch (CRLException e) {
            throw new DSSException((Throwable)e);
        }
    }

    static {
        try {
            Security.addProvider((Provider)BC_PROVIDER);
            CERT_FACTORY = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (CertificateException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new DSSException("Platform does not support X509 certificate", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new DSSException("Platform does not support BouncyCastle", (Throwable)e);
        }
    }
}

