/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.crl.ICRLUtils;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CRLEntry;
import java.util.Iterator;
import java.util.ServiceLoader;

public class CRLUtils {
    private static ICRLUtils impl;

    private CRLUtils() {
    }

    public static CRLBinary buildCRLBinary(byte[] binaries) throws IOException {
        return impl.buildCRLBinary(binaries);
    }

    public static CRLValidity buildCRLValidity(CRLBinary crlBinary, CertificateToken issuerToken) throws IOException {
        return impl.buildCRLValidity(crlBinary, issuerToken);
    }

    public static X509CRLEntry getRevocationInfo(CRLValidity crlValidity, BigInteger serialNumber) {
        return impl.getRevocationInfo(crlValidity, serialNumber);
    }

    static {
        ServiceLoader<ICRLUtils> loader = ServiceLoader.load(ICRLUtils.class);
        Iterator<ICRLUtils> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new ExceptionInInitializerError("No implementation found for ICRLUtils in classpath, please choose between dss-crl-parser-stream or dss-crl-parser-x509crl");
        }
        impl = iterator.next();
    }
}

