/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.validation.CertificateStatusVerifier;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.crl.CRLToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLCertificateVerifier
implements CertificateStatusVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(CRLCertificateVerifier.class);
    private final CRLSource crlSource;

    public CRLCertificateVerifier(CRLSource crlSource) {
        this.crlSource = crlSource;
    }

    @Override
    public RevocationToken check(CertificateToken certificateToken) {
        try {
            if (this.crlSource == null) {
                certificateToken.extraInfo().infoCRLSourceIsNull();
                return null;
            }
            CRLToken crlToken = this.crlSource.findCrl(certificateToken);
            if (crlToken == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("No CRL found for: " + certificateToken.getDSSIdAsString());
                }
                certificateToken.extraInfo().infoNoCRLInfoFound();
                return null;
            }
            if (!crlToken.isValid()) {
                LOG.warn("The CRL is not valid !");
                certificateToken.extraInfo().infoCRLIsNotValid();
                return null;
            }
            certificateToken.addRevocationToken((RevocationToken)crlToken);
            return crlToken;
        }
        catch (Exception e) {
            LOG.error("Exception when accessing CRL for " + certificateToken.getDSSIdAsString(), (Throwable)e);
            certificateToken.extraInfo().infoCRLException(e.getMessage());
            return null;
        }
    }
}

