/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import org.bouncycastle.asn1.esf.CrlIdentifier;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OtherHash;
import org.bouncycastle.asn1.x500.X500Name;

public final class CRLRef {
    private X500Name crlIssuer;
    private Date crlIssuedTime;
    private BigInteger crlNumber;
    private DigestAlgorithm digestAlgorithm;
    private byte[] digestValue;

    public CRLRef(DigestAlgorithm digestAlgorithm, byte[] digestValue) {
        this.digestAlgorithm = digestAlgorithm;
        this.digestValue = digestValue;
    }

    public CRLRef(CrlValidatedID cmsRef) {
        try {
            CrlIdentifier crlIdentifier = cmsRef.getCrlIdentifier();
            if (crlIdentifier != null) {
                this.crlIssuer = crlIdentifier.getCrlIssuer();
                this.crlIssuedTime = crlIdentifier.getCrlIssuedTime().getDate();
                this.crlNumber = crlIdentifier.getCrlNumber();
            }
            OtherHash crlHash = cmsRef.getCrlHash();
            this.digestAlgorithm = DigestAlgorithm.forOID((String)crlHash.getHashAlgorithm().getAlgorithm().getId());
            this.digestValue = crlHash.getHashValue();
        }
        catch (ParseException ex) {
            throw new DSSException((Throwable)ex);
        }
    }

    public boolean match(X509CRL crl) {
        try {
            MessageDigest digest = DSSUtils.getMessageDigest((DigestAlgorithm)this.digestAlgorithm);
            byte[] computedValue = digest.digest(crl.getEncoded());
            return Arrays.equals(this.digestValue, computedValue);
        }
        catch (CRLException ex) {
            throw new DSSException((Throwable)ex);
        }
    }

    public X500Name getCrlIssuer() {
        return this.crlIssuer;
    }

    public Date getCrlIssuedTime() {
        return this.crlIssuedTime;
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }
}

