/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.Serializable;
import java.security.PublicKey;

public class CertificateValidity
implements Serializable {
    private PublicKey publicKey;
    private CertificateToken certificateToken;
    private boolean signerIdMatch;
    private boolean digestPresent;
    private boolean digestEqual;
    private boolean attributePresent;
    private boolean serialNumberEqual;
    private boolean distinguishedNameEqual;
    private String signed;
    private String digest;
    private DigestAlgorithm digestAlgorithm;

    public CertificateValidity(CertificateToken certificateToken) {
        this.certificateToken = certificateToken;
    }

    public CertificateValidity(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PublicKey getPublicKey() {
        return this.certificateToken == null ? this.publicKey : this.certificateToken.getPublicKey();
    }

    public CertificateToken getCertificateToken() {
        return this.certificateToken;
    }

    public boolean isSignerIdMatch() {
        return this.signerIdMatch;
    }

    public void setSignerIdMatch(boolean signerIdMatch) {
        this.signerIdMatch = signerIdMatch;
    }

    public boolean isDigestPresent() {
        return this.digestPresent;
    }

    public void setDigestPresent(boolean digestPresent) {
        this.digestPresent = digestPresent;
    }

    public boolean isDigestEqual() {
        return this.digestEqual;
    }

    public void setDigestEqual(boolean digestEqual) {
        this.digestEqual = digestEqual;
    }

    public boolean isAttributePresent() {
        return this.attributePresent;
    }

    public void setAttributePresent(boolean attributePresent) {
        this.attributePresent = attributePresent;
    }

    public boolean isSerialNumberEqual() {
        return this.serialNumberEqual;
    }

    public void setSerialNumberEqual(boolean serialNumberEqual) {
        this.serialNumberEqual = serialNumberEqual;
    }

    public void setDistinguishedNameEqual(boolean distinguishedNameEqual) {
        this.distinguishedNameEqual = distinguishedNameEqual;
    }

    public boolean isDistinguishedNameEqual() {
        return this.distinguishedNameEqual;
    }

    public String getSigned() {
        return this.signed;
    }

    public void setSigned(String signed) {
        this.signed = signed;
    }

    public boolean isValid() {
        boolean valid = this.isDigestEqual() || this.isDistinguishedNameEqual() && this.isSerialNumberEqual() || Utils.isStringNotEmpty((String)this.getSigned());
        return valid;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDigest() {
        return this.digest;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }
}

