/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.client.http.NativeHTTPDataLoader;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.crl.ListCRLSource;
import eu.europa.esig.dss.x509.ocsp.ListOCSPSource;
import eu.europa.esig.dss.x509.ocsp.OCSPSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonCertificateVerifier
implements CertificateVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCertificateVerifier.class);
    private CertificateSource trustedCertSource;
    private CertificateSource adjunctCertSource;
    private OCSPSource ocspSource;
    private CRLSource crlSource;
    private DataLoader dataLoader;
    private ListCRLSource signatureCRLSource;
    private ListOCSPSource signatureOCSPSource;

    public CommonCertificateVerifier() {
        LOG.info("+ New CommonCertificateVerifier created.");
        this.dataLoader = new NativeHTTPDataLoader();
    }

    public CommonCertificateVerifier(boolean simpleCreationOnly) {
        if (!simpleCreationOnly) {
            this.dataLoader = new NativeHTTPDataLoader();
        }
    }

    public CommonCertificateVerifier(CertificateSource trustedCertSource, CRLSource crlSource, OCSPSource ocspSource, DataLoader dataLoader) {
        LOG.info("+ New CommonCertificateVerifier created with parameters.");
        this.trustedCertSource = trustedCertSource;
        this.crlSource = crlSource;
        this.ocspSource = ocspSource;
        this.dataLoader = dataLoader;
        if (dataLoader == null) {
            LOG.warn("DataLoader is null. It's required to access AIA certificate source");
        }
    }

    @Override
    public CertificateSource getTrustedCertSource() {
        return this.trustedCertSource;
    }

    @Override
    public OCSPSource getOcspSource() {
        return this.ocspSource;
    }

    @Override
    public CRLSource getCrlSource() {
        return this.crlSource;
    }

    @Override
    public void setCrlSource(CRLSource crlSource) {
        this.crlSource = crlSource;
    }

    @Override
    public void setOcspSource(OCSPSource ocspSource) {
        this.ocspSource = ocspSource;
    }

    @Override
    public void setTrustedCertSource(CertificateSource trustedCertSource) {
        this.trustedCertSource = trustedCertSource;
    }

    @Override
    public CertificateSource getAdjunctCertSource() {
        return this.adjunctCertSource;
    }

    @Override
    public void setAdjunctCertSource(CertificateSource adjunctCertSource) {
        this.adjunctCertSource = adjunctCertSource;
    }

    @Override
    public DataLoader getDataLoader() {
        return this.dataLoader;
    }

    @Override
    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    @Override
    public ListCRLSource getSignatureCRLSource() {
        return this.signatureCRLSource;
    }

    @Override
    public void setSignatureCRLSource(ListCRLSource signatureCRLSource) {
        this.signatureCRLSource = signatureCRLSource;
    }

    @Override
    public ListOCSPSource getSignatureOCSPSource() {
        return this.signatureOCSPSource;
    }

    @Override
    public void setSignatureOCSPSource(ListOCSPSource signatureOCSPSource) {
        this.signatureOCSPSource = signatureOCSPSource;
    }

    @Override
    public CertificatePool createValidationPool() {
        CertificatePool validationPool = new CertificatePool();
        if (this.trustedCertSource != null) {
            validationPool.merge(this.trustedCertSource.getCertificatePool());
        }
        if (this.adjunctCertSource != null) {
            validationPool.merge(this.adjunctCertSource.getCertificatePool());
        }
        return validationPool;
    }
}

