/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSPKUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.MaskGenerationFunction;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.jaxb.diagnostic.DiagnosticData;
import eu.europa.esig.dss.jaxb.diagnostic.XmlBasicSignature;
import eu.europa.esig.dss.jaxb.diagnostic.XmlCertificate;
import eu.europa.esig.dss.jaxb.diagnostic.XmlCertifiedRole;
import eu.europa.esig.dss.jaxb.diagnostic.XmlChainItem;
import eu.europa.esig.dss.jaxb.diagnostic.XmlContainerInfo;
import eu.europa.esig.dss.jaxb.diagnostic.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.jaxb.diagnostic.XmlDistinguishedName;
import eu.europa.esig.dss.jaxb.diagnostic.XmlManifestFile;
import eu.europa.esig.dss.jaxb.diagnostic.XmlMessage;
import eu.europa.esig.dss.jaxb.diagnostic.XmlOID;
import eu.europa.esig.dss.jaxb.diagnostic.XmlPolicy;
import eu.europa.esig.dss.jaxb.diagnostic.XmlRevocation;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSignature;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSignatureProductionPlace;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSignatureScope;
import eu.europa.esig.dss.jaxb.diagnostic.XmlSigningCertificate;
import eu.europa.esig.dss.jaxb.diagnostic.XmlStructuralValidation;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTimestamp;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTimestampedObject;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedList;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedService;
import eu.europa.esig.dss.jaxb.diagnostic.XmlTrustedServiceProvider;
import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.tsl.KeyUsageBit;
import eu.europa.esig.dss.tsl.ServiceInfo;
import eu.europa.esig.dss.tsl.ServiceInfoStatus;
import eu.europa.esig.dss.tsl.TLInfo;
import eu.europa.esig.dss.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.BasicASNSignaturePolicyValidator;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CertifiedRole;
import eu.europa.esig.dss.validation.CommitmentType;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.OidRepository;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignaturePolicyValidator;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignatureScope;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.TimestampedObjectType;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.SignaturePolicy;
import eu.europa.esig.dss.x509.Token;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosticDataBuilder.class);
    private DSSDocument signedDocument;
    private ContainerInfo containerInfo;
    private List<AdvancedSignature> signatures;
    private Set<CertificateToken> usedCertificates;
    private TrustedListsCertificateSource trustedListCertSource;
    private Date validationDate;

    public DiagnosticDataBuilder document(DSSDocument signedDocument) {
        this.signedDocument = signedDocument;
        return this;
    }

    public DiagnosticDataBuilder containerInfo(ContainerInfo containerInfo) {
        this.containerInfo = containerInfo;
        return this;
    }

    public DiagnosticDataBuilder foundSignatures(List<AdvancedSignature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public DiagnosticDataBuilder usedCertificates(Set<CertificateToken> usedCertificates) {
        this.usedCertificates = usedCertificates;
        return this;
    }

    public DiagnosticDataBuilder trustedListsCertificateSource(CertificateSource trustedCertSource) {
        if (trustedCertSource instanceof TrustedListsCertificateSource) {
            this.trustedListCertSource = (TrustedListsCertificateSource)trustedCertSource;
        }
        return this;
    }

    public DiagnosticDataBuilder validationDate(Date validationDate) {
        this.validationDate = validationDate;
        return this;
    }

    public DiagnosticData build() {
        DiagnosticData diagnosticData = new DiagnosticData();
        if (this.signedDocument != null) {
            diagnosticData.setDocumentName(this.removeSpecialCharsForXml(this.signedDocument.getName()));
        }
        diagnosticData.setValidationDate(this.validationDate);
        diagnosticData.setContainerInfo(this.getXmlContainerInfo());
        HashSet<DigestAlgorithm> allUsedCertificatesDigestAlgorithms = new HashSet<DigestAlgorithm>();
        if (Utils.isCollectionNotEmpty(this.signatures)) {
            for (AdvancedSignature advancedSignature : this.signatures) {
                allUsedCertificatesDigestAlgorithms.addAll(advancedSignature.getUsedCertificatesDigestAlgorithms());
                diagnosticData.getSignatures().add(this.getXmlSignature(advancedSignature));
            }
        }
        ArrayList<XmlCertificate> xmlCertificates = new ArrayList<XmlCertificate>();
        HashSet<String> countryCodes = new HashSet<String>();
        if (Utils.isCollectionNotEmpty(this.usedCertificates)) {
            for (CertificateToken certificateToken : this.usedCertificates) {
                xmlCertificates.add(this.getXmlCertificate(allUsedCertificatesDigestAlgorithms, certificateToken));
                Set associatedTSPS = certificateToken.getAssociatedTSPS();
                if (!Utils.isCollectionNotEmpty((Collection)associatedTSPS)) continue;
                for (ServiceInfo serviceInfo : associatedTSPS) {
                    countryCodes.add(serviceInfo.getTlCountryCode());
                }
            }
        }
        diagnosticData.setUsedCertificates(Collections.unmodifiableList(xmlCertificates));
        if (this.trustedListCertSource != null) {
            boolean addLOTL = false;
            for (String countryCode : countryCodes) {
                TLInfo tlInfo = this.trustedListCertSource.getTlInfo(countryCode);
                if (tlInfo == null) continue;
                diagnosticData.getTrustedLists().add(this.getXmlTrustedList(countryCode, tlInfo));
                addLOTL = true;
            }
            if (addLOTL) {
                diagnosticData.setListOfTrustedLists(this.getXmlTrustedList("LOTL", this.trustedListCertSource.getLotlInfo()));
            }
        }
        return diagnosticData;
    }

    private XmlTrustedList getXmlTrustedList(String countryCode, TLInfo tlInfo) {
        if (tlInfo != null) {
            XmlTrustedList result = new XmlTrustedList();
            result.setCountryCode(tlInfo.getCountryCode());
            result.setUrl(tlInfo.getUrl());
            result.setIssueDate(tlInfo.getIssueDate());
            result.setNextUpdate(tlInfo.getNextUpdate());
            result.setLastLoading(tlInfo.getLastLoading());
            result.setSequenceNumber(Integer.valueOf(tlInfo.getSequenceNumber()));
            result.setVersion(Integer.valueOf(tlInfo.getVersion()));
            result.setWellSigned(tlInfo.isWellSigned());
            return result;
        }
        LOG.warn("Not info found for country " + countryCode);
        return null;
    }

    private XmlContainerInfo getXmlContainerInfo() {
        if (this.containerInfo != null) {
            XmlContainerInfo xmlContainerInfo = new XmlContainerInfo();
            xmlContainerInfo.setContainerType(this.containerInfo.getContainerType().getReadable());
            String zipComment = this.containerInfo.getZipComment();
            if (Utils.isStringNotBlank((String)zipComment)) {
                xmlContainerInfo.setZipComment(zipComment);
            }
            xmlContainerInfo.setMimeTypeFilePresent(Boolean.valueOf(this.containerInfo.isMimeTypeFilePresent()));
            xmlContainerInfo.setMimeTypeContent(this.containerInfo.getMimeTypeContent());
            xmlContainerInfo.setContentFiles(this.containerInfo.getSignedDocumentFilenames());
            xmlContainerInfo.setManifestFiles(this.getXmlManifests(this.containerInfo.getManifestFiles()));
            return xmlContainerInfo;
        }
        return null;
    }

    private List<XmlManifestFile> getXmlManifests(List<ManifestFile> manifestFiles) {
        if (Utils.isCollectionNotEmpty(manifestFiles)) {
            ArrayList<XmlManifestFile> xmlManifests = new ArrayList<XmlManifestFile>();
            for (ManifestFile manifestFile : manifestFiles) {
                XmlManifestFile xmlManifest = new XmlManifestFile();
                xmlManifest.setFilename(manifestFile.getFilename());
                xmlManifest.setSignatureFilename(manifestFile.getSignatureFilename());
                xmlManifest.getEntries().addAll(manifestFile.getEntries());
                xmlManifests.add(xmlManifest);
            }
            return xmlManifests;
        }
        return null;
    }

    private XmlSignature getXmlSignature(AdvancedSignature signature) {
        XmlSignature xmlSignature = new XmlSignature();
        xmlSignature.setSignatureFilename(this.removeSpecialCharsForXml(signature.getSignatureFilename()));
        AdvancedSignature masterSignature = signature.getMasterSignature();
        if (masterSignature != null) {
            xmlSignature.setCounterSignature(Boolean.valueOf(true));
            xmlSignature.setParentId(masterSignature.getId());
            xmlSignature.setSignatureFilename(this.removeSpecialCharsForXml(masterSignature.getSignatureFilename()));
        }
        xmlSignature.setId(signature.getId());
        xmlSignature.setDateTime(signature.getSigningTime());
        xmlSignature.setStructuralValidation(this.getXmlStructuralValidation(signature));
        xmlSignature.setSignatureFormat(this.getXmlSignatureFormat(signature.getDataFoundUpToLevel()));
        xmlSignature.setSignatureProductionPlace(this.getXmlSignatureProductionPlace(signature.getSignatureProductionPlace()));
        xmlSignature.setCommitmentTypeIndication(this.getXmlCommitmentTypeIndication(signature.getCommitmentTypeIndication()));
        xmlSignature.setClaimedRoles(this.getXmlClaimedRole(signature.getClaimedSignerRoles()));
        xmlSignature.getCertifiedRoles().addAll(this.getXmlCertifiedRoles(signature.getCertifiedSignerRoles()));
        xmlSignature.setContentType(signature.getContentType());
        xmlSignature.setContentIdentifier(signature.getContentIdentifier());
        xmlSignature.setContentHints(signature.getContentHints());
        CertificateToken signingCertificateToken = null;
        CandidatesForSigningCertificate candidatesForSigningCertificate = signature.getCandidatesForSigningCertificate();
        CertificateValidity theCertificateValidity = candidatesForSigningCertificate.getTheCertificateValidity();
        if (theCertificateValidity != null) {
            xmlSignature.setSigningCertificate(this.getXmlSigningCertificate(theCertificateValidity));
            signingCertificateToken = theCertificateValidity.getCertificateToken();
        }
        xmlSignature.setCertificateChain(this.getXmlForCertificateChain(signingCertificateToken));
        xmlSignature.setBasicSignature(this.getXmlBasicSignature(signature, signingCertificateToken));
        xmlSignature.setPolicy(this.getXmlPolicy(signature));
        xmlSignature.setTimestamps(this.getXmlTimestamps(signature));
        xmlSignature.setSignatureScopes(this.getXmlSignatureScopes(signature.getSignatureScopes()));
        return xmlSignature;
    }

    private XmlStructuralValidation getXmlStructuralValidation(AdvancedSignature signature) {
        String structureValidationResult = signature.getStructureValidationResult();
        XmlStructuralValidation xmlStructuralValidation = new XmlStructuralValidation();
        xmlStructuralValidation.setValid(Boolean.valueOf(Utils.isStringEmpty((String)structureValidationResult)));
        if (Utils.isStringNotEmpty((String)structureValidationResult)) {
            xmlStructuralValidation.setMessage(structureValidationResult);
        }
        return xmlStructuralValidation;
    }

    private String removeSpecialCharsForXml(String text) {
        if (Utils.isStringNotEmpty((String)text)) {
            return text.replaceAll("&", "");
        }
        return "";
    }

    private XmlRevocation getXmlRevocation(RevocationToken revocationToken, String xmlId, Set<DigestAlgorithm> usedDigestAlgorithms) {
        XmlRevocation xmlRevocation = new XmlRevocation();
        xmlRevocation.setId(xmlId);
        xmlRevocation.setOrigin(revocationToken.getOrigin().name());
        Boolean revocationTokenStatus = revocationToken.getStatus();
        xmlRevocation.setStatus(revocationTokenStatus == null ? false : revocationTokenStatus);
        xmlRevocation.setProductionDate(revocationToken.getProductionDate());
        xmlRevocation.setThisUpdate(revocationToken.getThisUpdate());
        xmlRevocation.setNextUpdate(revocationToken.getNextUpdate());
        xmlRevocation.setRevocationDate(revocationToken.getRevocationDate());
        xmlRevocation.setExpiredCertsOnCRL(revocationToken.getExpiredCertsOnCRL());
        xmlRevocation.setArchiveCutOff(revocationToken.getArchiveCutOff());
        xmlRevocation.setReason(revocationToken.getReason());
        xmlRevocation.setSource(revocationToken.getClass().getSimpleName());
        String sourceURL = revocationToken.getSourceURL();
        if (Utils.isStringNotEmpty((String)sourceURL)) {
            xmlRevocation.setSourceAddress(sourceURL);
            xmlRevocation.setAvailable(Boolean.valueOf(revocationToken.isAvailable()));
        }
        xmlRevocation.setBasicSignature(this.getXmlBasicSignature((Token)revocationToken));
        xmlRevocation.setDigestAlgoAndValues(this.getXmlDigestAlgoAndValues(usedDigestAlgorithms, (Token)revocationToken));
        CertificateToken issuerToken = revocationToken.getIssuerToken();
        xmlRevocation.setSigningCertificate(this.getXmlSigningCertificate(issuerToken));
        xmlRevocation.setCertificateChain(this.getXmlForCertificateChain(issuerToken));
        xmlRevocation.setInfo(this.getXmlInfo(revocationToken.getValidationInfo()));
        return xmlRevocation;
    }

    private List<XmlDigestAlgoAndValue> getXmlDigestAlgoAndValues(Set<DigestAlgorithm> usedDigestAlgorithms, Token token) {
        ArrayList<XmlDigestAlgoAndValue> result = new ArrayList<XmlDigestAlgoAndValue>();
        for (DigestAlgorithm digestAlgorithm : usedDigestAlgorithms) {
            result.add(this.getXmlDigestAlgoAndValue(digestAlgorithm, Utils.toBase64((byte[])token.getDigest(digestAlgorithm))));
        }
        return result;
    }

    private List<XmlMessage> getXmlInfo(List<String> infos) {
        ArrayList<XmlMessage> messages = new ArrayList<XmlMessage>();
        if (Utils.isCollectionNotEmpty(infos)) {
            int i = 0;
            for (String message : infos) {
                XmlMessage xmlMessage = new XmlMessage();
                xmlMessage.setId(i);
                xmlMessage.setValue(message);
                messages.add(xmlMessage);
                ++i;
            }
        }
        return messages;
    }

    private List<XmlChainItem> getXmlForCertificateChain(CertificateToken token) {
        if (token != null) {
            CertificateToken issuerToken_ = token;
            ArrayList<XmlChainItem> certChainTokens = new ArrayList<XmlChainItem>();
            do {
                certChainTokens.add(this.getXmlChainItem(issuerToken_));
            } while (!issuerToken_.isTrusted() && !issuerToken_.isSelfSigned() && (issuerToken_ = issuerToken_.getIssuerToken()) != null);
            return certChainTokens;
        }
        return null;
    }

    private XmlChainItem getXmlChainItem(CertificateToken token) {
        XmlChainItem chainItem = new XmlChainItem();
        chainItem.setId(token.getDSSIdAsString());
        chainItem.setSource(this.getCertificateMainSourceType(token).name());
        return chainItem;
    }

    private CertificateSourceType getCertificateMainSourceType(CertificateToken issuerToken) {
        CertificateSourceType mainSource = CertificateSourceType.UNKNOWN;
        Set sourceList = issuerToken.getSources();
        if (sourceList.size() > 0) {
            mainSource = sourceList.contains(CertificateSourceType.TRUSTED_LIST) ? CertificateSourceType.TRUSTED_LIST : (sourceList.contains(CertificateSourceType.TRUSTED_STORE) ? CertificateSourceType.TRUSTED_STORE : (CertificateSourceType)sourceList.iterator().next());
        }
        return mainSource;
    }

    private XmlSigningCertificate getXmlSigningCertificate(CertificateToken token) {
        if (token != null) {
            XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
            xmlSignCertType.setId(token.getDSSIdAsString());
            return xmlSignCertType;
        }
        return null;
    }

    private XmlSigningCertificate getXmlSigningCertificate(CertificateValidity theCertificateValidity) {
        XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
        CertificateToken signingCertificateToken = theCertificateValidity.getCertificateToken();
        if (signingCertificateToken != null) {
            xmlSignCertType.setId(signingCertificateToken.getDSSIdAsString());
        }
        xmlSignCertType.setAttributePresent(Boolean.valueOf(theCertificateValidity.isAttributePresent()));
        xmlSignCertType.setDigestValuePresent(Boolean.valueOf(theCertificateValidity.isDigestPresent()));
        xmlSignCertType.setDigestValueMatch(Boolean.valueOf(theCertificateValidity.isDigestEqual()));
        boolean issuerSerialMatch = theCertificateValidity.isSerialNumberEqual() && theCertificateValidity.isDistinguishedNameEqual();
        xmlSignCertType.setIssuerSerialMatch(Boolean.valueOf(issuerSerialMatch));
        xmlSignCertType.setSigned(theCertificateValidity.getSigned());
        return xmlSignCertType;
    }

    private XmlSignatureProductionPlace getXmlSignatureProductionPlace(SignatureProductionPlace signatureProductionPlace) {
        if (signatureProductionPlace != null) {
            XmlSignatureProductionPlace xmlSignatureProductionPlace = new XmlSignatureProductionPlace();
            xmlSignatureProductionPlace.setCountryName(signatureProductionPlace.getCountryName());
            xmlSignatureProductionPlace.setStateOrProvince(signatureProductionPlace.getStateOrProvince());
            xmlSignatureProductionPlace.setPostalCode(signatureProductionPlace.getPostalCode());
            xmlSignatureProductionPlace.setAddress(signatureProductionPlace.getStreetAddress());
            xmlSignatureProductionPlace.setCity(signatureProductionPlace.getCity());
            return xmlSignatureProductionPlace;
        }
        return null;
    }

    private List<XmlCertifiedRole> getXmlCertifiedRoles(List<CertifiedRole> certifiedRoles) {
        ArrayList<XmlCertifiedRole> xmlCertRoles = new ArrayList<XmlCertifiedRole>();
        if (Utils.isCollectionNotEmpty(certifiedRoles)) {
            for (CertifiedRole certifiedRole : certifiedRoles) {
                XmlCertifiedRole xmlCertifiedRole = new XmlCertifiedRole();
                xmlCertifiedRole.setCertifiedRole(certifiedRole.getRole());
                xmlCertifiedRole.setNotBefore(certifiedRole.getNotBefore());
                xmlCertifiedRole.setNotAfter(certifiedRole.getNotAfter());
                xmlCertRoles.add(xmlCertifiedRole);
            }
            return xmlCertRoles;
        }
        return Collections.emptyList();
    }

    private List<String> getXmlClaimedRole(String[] claimedRoles) {
        if (Utils.isArrayNotEmpty((Object[])claimedRoles)) {
            return Arrays.asList(claimedRoles);
        }
        return Collections.emptyList();
    }

    private List<String> getXmlCommitmentTypeIndication(CommitmentType commitmentTypeIndication) {
        if (commitmentTypeIndication != null) {
            return commitmentTypeIndication.getIdentifiers();
        }
        return Collections.emptyList();
    }

    private String getXmlSignatureFormat(SignatureLevel signatureLevel) {
        return signatureLevel == null ? "UNKNOWN" : signatureLevel.toString();
    }

    private XmlDistinguishedName getXmlDistinguishedName(String x500PrincipalFormat, X500Principal X500PrincipalName) {
        XmlDistinguishedName xmlDistinguishedName = new XmlDistinguishedName();
        xmlDistinguishedName.setFormat(x500PrincipalFormat);
        xmlDistinguishedName.setValue(X500PrincipalName.getName(x500PrincipalFormat));
        return xmlDistinguishedName;
    }

    private List<XmlTimestamp> getXmlTimestamps(AdvancedSignature signature) {
        ArrayList<XmlTimestamp> xmlTimestamps = new ArrayList<XmlTimestamp>();
        xmlTimestamps.addAll(this.getXmlTimestamps(signature.getContentTimestamps()));
        xmlTimestamps.addAll(this.getXmlTimestamps(signature.getSignatureTimestamps()));
        xmlTimestamps.addAll(this.getXmlTimestamps(signature.getTimestampsX1()));
        xmlTimestamps.addAll(this.getXmlTimestamps(signature.getTimestampsX2()));
        xmlTimestamps.addAll(this.getXmlTimestamps(signature.getArchiveTimestamps()));
        return xmlTimestamps;
    }

    private XmlPolicy getXmlPolicy(AdvancedSignature signature) {
        SignaturePolicy signaturePolicy = signature.getPolicyId();
        if (signaturePolicy == null) {
            return null;
        }
        XmlPolicy xmlPolicy = new XmlPolicy();
        String policyId = signaturePolicy.getIdentifier();
        xmlPolicy.setId(policyId);
        String policyUrl = signaturePolicy.getUrl();
        xmlPolicy.setUrl(policyUrl);
        String notice = signaturePolicy.getNotice();
        xmlPolicy.setNotice(notice);
        String digestValue = signaturePolicy.getDigestValue();
        DigestAlgorithm signPolicyHashAlgFromSignature = signaturePolicy.getDigestAlgorithm();
        if (Utils.isStringNotEmpty((String)digestValue)) {
            xmlPolicy.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(signPolicyHashAlgFromSignature, digestValue));
        }
        try {
            SignaturePolicyValidator validator = null;
            ServiceLoader<SignaturePolicyValidator> loader = ServiceLoader.load(SignaturePolicyValidator.class);
            Iterator<SignaturePolicyValidator> validatorOptions = loader.iterator();
            if (validatorOptions.hasNext()) {
                for (SignaturePolicyValidator signaturePolicyValidator : loader) {
                    signaturePolicyValidator.setSignature(signature);
                    if (!signaturePolicyValidator.canValidate()) continue;
                    validator = signaturePolicyValidator;
                    break;
                }
            }
            if (validator == null) {
                validator = new BasicASNSignaturePolicyValidator();
                validator.setSignature(signature);
            }
            validator.validate();
            xmlPolicy.setAsn1Processable(Boolean.valueOf(validator.isAsn1Processable()));
            xmlPolicy.setDigestAlgorithmsEqual(Boolean.valueOf(validator.isDigestAlgorithmsEqual()));
            xmlPolicy.setIdentified(Boolean.valueOf(validator.isIdentified()));
            xmlPolicy.setStatus(Boolean.valueOf(validator.isStatus()));
            xmlPolicy.setProcessingError(validator.getProcessingErrors());
        }
        catch (Exception e) {
            xmlPolicy.setStatus(Boolean.valueOf(false));
            xmlPolicy.setProcessingError(e.getMessage());
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return xmlPolicy;
    }

    private List<XmlTimestamp> getXmlTimestamps(List<TimestampToken> timestamps) {
        ArrayList<XmlTimestamp> xmlTimestamps = new ArrayList<XmlTimestamp>();
        if (Utils.isCollectionNotEmpty(timestamps)) {
            for (TimestampToken timestampToken : timestamps) {
                xmlTimestamps.add(this.getXmlTimestamp(timestampToken));
            }
        }
        return xmlTimestamps;
    }

    private XmlTimestamp getXmlTimestamp(TimestampToken timestampToken) {
        XmlTimestamp xmlTimestampToken = new XmlTimestamp();
        xmlTimestampToken.setId(timestampToken.getDSSIdAsString());
        xmlTimestampToken.setType(timestampToken.getTimeStampType().name());
        xmlTimestampToken.setProductionTime(timestampToken.getGenerationTime());
        xmlTimestampToken.setSignedDataDigestAlgo(timestampToken.getSignedDataDigestAlgo().getName());
        xmlTimestampToken.setEncodedSignedDataDigestValue(timestampToken.getEncodedSignedDataDigestValue());
        xmlTimestampToken.setMessageImprintDataFound(timestampToken.isMessageImprintDataFound().booleanValue());
        xmlTimestampToken.setMessageImprintDataIntact(timestampToken.isMessageImprintDataIntact().booleanValue());
        xmlTimestampToken.setCanonicalizationMethod(timestampToken.getCanonicalizationMethod());
        xmlTimestampToken.setBasicSignature(this.getXmlBasicSignature(timestampToken));
        CertificateToken issuerToken = timestampToken.getIssuerToken();
        xmlTimestampToken.setSigningCertificate(this.getXmlSigningCertificate(issuerToken));
        xmlTimestampToken.setCertificateChain(this.getXmlForCertificateChain(issuerToken));
        xmlTimestampToken.setTimestampedObjects(this.getXmlTimestampedObjects(timestampToken.getTimestampedReferences()));
        return xmlTimestampToken;
    }

    private List<XmlTimestampedObject> getXmlTimestampedObjects(List<TimestampReference> timestampReferences) {
        if (Utils.isCollectionNotEmpty(timestampReferences)) {
            ArrayList<XmlTimestampedObject> objects = new ArrayList<XmlTimestampedObject>();
            for (TimestampReference timestampReference : timestampReferences) {
                XmlTimestampedObject timestampedObject = new XmlTimestampedObject();
                TimestampedObjectType timestampedCategory = timestampReference.getCategory();
                timestampedObject.setCategory(timestampReference.getCategory());
                if (TimestampedObjectType.SIGNATURE == timestampedCategory || TimestampedObjectType.TIMESTAMP == timestampedCategory) {
                    timestampedObject.setId(timestampReference.getSignatureId());
                } else {
                    timestampedObject.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(timestampReference.getDigestAlgorithm(), timestampReference.getDigestValue()));
                }
                objects.add(timestampedObject);
            }
            return objects;
        }
        return null;
    }

    private XmlBasicSignature getXmlBasicSignature(Token token) {
        XmlBasicSignature xmlBasicSignatureType = new XmlBasicSignature();
        SignatureAlgorithm signatureAlgorithm = token.getSignatureAlgorithm();
        if (signatureAlgorithm != null) {
            xmlBasicSignatureType.setEncryptionAlgoUsedToSignThisToken(signatureAlgorithm.getEncryptionAlgorithm().getName());
            xmlBasicSignatureType.setDigestAlgoUsedToSignThisToken(signatureAlgorithm.getDigestAlgorithm().getName());
        }
        xmlBasicSignatureType.setKeyLengthUsedToSignThisToken(DSSPKUtils.getPublicKeySize((Token)token));
        boolean signatureValid = token.isSignatureValid();
        xmlBasicSignatureType.setReferenceDataFound(signatureValid);
        xmlBasicSignatureType.setReferenceDataIntact(signatureValid);
        xmlBasicSignatureType.setSignatureIntact(signatureValid);
        xmlBasicSignatureType.setSignatureValid(signatureValid);
        return xmlBasicSignatureType;
    }

    private List<String> getXmlKeyUsages(Set<KeyUsageBit> keyUsageBits) {
        ArrayList<String> xmlKeyUsageBitItems = new ArrayList<String>();
        if (Utils.isCollectionNotEmpty(keyUsageBits)) {
            for (KeyUsageBit keyUsageBit : keyUsageBits) {
                xmlKeyUsageBitItems.add(keyUsageBit.name());
            }
        }
        return xmlKeyUsageBitItems;
    }

    private XmlBasicSignature getXmlBasicSignature(AdvancedSignature signature, CertificateToken signingCertificateToken) {
        XmlBasicSignature xmlBasicSignature = new XmlBasicSignature();
        EncryptionAlgorithm encryptionAlgorithm = signature.getEncryptionAlgorithm();
        String encryptionAlgorithmString = encryptionAlgorithm == null ? "?" : encryptionAlgorithm.getName();
        xmlBasicSignature.setEncryptionAlgoUsedToSignThisToken(encryptionAlgorithmString);
        int keyLength = signingCertificateToken == null ? 0 : this.getkeyLenght(signingCertificateToken);
        xmlBasicSignature.setKeyLengthUsedToSignThisToken(String.valueOf(keyLength));
        DigestAlgorithm digestAlgorithm = signature.getDigestAlgorithm();
        String digestAlgorithmString = digestAlgorithm == null ? "?" : digestAlgorithm.getName();
        xmlBasicSignature.setDigestAlgoUsedToSignThisToken(digestAlgorithmString);
        MaskGenerationFunction maskGenerationFunction = signature.getMaskGenerationFunction();
        if (maskGenerationFunction != null) {
            xmlBasicSignature.setMaskGenerationFunctionUsedToSignThisToken(maskGenerationFunction.name());
        }
        SignatureCryptographicVerification scv = signature.getSignatureCryptographicVerification();
        xmlBasicSignature.setReferenceDataFound(scv.isReferenceDataFound());
        xmlBasicSignature.setReferenceDataIntact(scv.isReferenceDataIntact());
        xmlBasicSignature.setSignatureIntact(scv.isSignatureIntact());
        xmlBasicSignature.setSignatureValid(scv.isSignatureValid());
        return xmlBasicSignature;
    }

    private int getkeyLenght(CertificateToken signingCertificateToken) {
        try {
            PublicKey publicKey = signingCertificateToken.getPublicKey();
            return DSSPKUtils.getPublicKeySize((PublicKey)publicKey);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Getting public key from certifcate in Bouncy Castle failed: {}", (Object)e.getMessage());
            return 0;
        }
    }

    private List<XmlSignatureScope> getXmlSignatureScopes(List<SignatureScope> scopes) {
        ArrayList<XmlSignatureScope> xmlScopes = new ArrayList<XmlSignatureScope>();
        if (Utils.isCollectionNotEmpty(scopes)) {
            for (SignatureScope xmlSignatureScope : scopes) {
                xmlScopes.add(this.getXmlSignatureScope(xmlSignatureScope));
            }
        }
        return xmlScopes;
    }

    private XmlSignatureScope getXmlSignatureScope(SignatureScope scope) {
        XmlSignatureScope xmlSignatureScope = new XmlSignatureScope();
        xmlSignatureScope.setName(scope.getName());
        xmlSignatureScope.setScope(scope.getType());
        xmlSignatureScope.setValue(scope.getDescription());
        return xmlSignatureScope;
    }

    private XmlCertificate getXmlCertificate(Set<DigestAlgorithm> usedDigestAlgorithms, CertificateToken certToken) {
        XmlCertificate xmlCert = new XmlCertificate();
        xmlCert.setId(certToken.getDSSIdAsString());
        xmlCert.setBase64Encoded(certToken.getEncoded());
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", certToken.getSubjectX500Principal()));
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", certToken.getSubjectX500Principal()));
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", certToken.getIssuerX500Principal()));
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", certToken.getIssuerX500Principal()));
        xmlCert.setSerialNumber(certToken.getSerialNumber());
        X500Principal x500Principal = certToken.getSubjectX500Principal();
        xmlCert.setCommonName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.CN, (X500Principal)x500Principal));
        xmlCert.setCountryName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.C, (X500Principal)x500Principal));
        xmlCert.setOrganizationName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.O, (X500Principal)x500Principal));
        xmlCert.setGivenName(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.GIVENNAME, (X500Principal)x500Principal));
        xmlCert.setOrganizationalUnit(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.OU, (X500Principal)x500Principal));
        xmlCert.setSurname(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.SURNAME, (X500Principal)x500Principal));
        xmlCert.setPseudonym(DSSASN1Utils.extractAttributeFromX500Principal((ASN1ObjectIdentifier)BCStyle.PSEUDONYM, (X500Principal)x500Principal));
        xmlCert.setAuthorityInformationAccessUrls(DSSASN1Utils.getCAAccessLocations((CertificateToken)certToken));
        xmlCert.setOCSPAccessUrls(DSSASN1Utils.getOCSPAccessLocations((CertificateToken)certToken, (boolean)false));
        xmlCert.setCRLDistributionPoints(DSSASN1Utils.getCrlUrls((CertificateToken)certToken, (boolean)false));
        xmlCert.setDigestAlgoAndValues(this.getXmlDigestAlgoAndValues(usedDigestAlgorithms, (Token)certToken));
        xmlCert.setNotAfter(certToken.getNotAfter());
        xmlCert.setNotBefore(certToken.getNotBefore());
        try {
            PublicKey publicKey = certToken.getPublicKey();
            xmlCert.setPublicKeySize(DSSPKUtils.getPublicKeySize((PublicKey)publicKey));
            xmlCert.setPublicKeyEncryptionAlgo(DSSPKUtils.getPublicKeyEncryptionAlgo((Key)publicKey));
        }
        catch (Exception e) {
            LOG.error("Technical exception: {}", (Object)e.getMessage().toUpperCase());
        }
        xmlCert.setKeyUsageBits(this.getXmlKeyUsages(certToken.getKeyUsageBits()));
        xmlCert.setIdKpOCSPSigning(Boolean.valueOf(DSSASN1Utils.isOCSPSigning((CertificateToken)certToken)));
        xmlCert.setIdPkixOcspNoCheck(Boolean.valueOf(DSSASN1Utils.hasIdPkixOcspNoCheckExtension((CertificateToken)certToken)));
        xmlCert.setBasicSignature(this.getXmlBasicSignature((Token)certToken));
        CertificateToken issuerToken = certToken.getIssuerToken();
        xmlCert.setSigningCertificate(this.getXmlSigningCertificate(issuerToken));
        xmlCert.setCertificateChain(this.getXmlForCertificateChain(issuerToken));
        xmlCert.setQCStatementIds(this.getXmlOids(DSSASN1Utils.getQCStatementsIdList((CertificateToken)certToken)));
        xmlCert.setQCTypes(this.getXmlOids(DSSASN1Utils.getQCTypesIdList((CertificateToken)certToken)));
        xmlCert.setCertificatePolicyIds(this.getXmlOids(DSSASN1Utils.getPolicyIdentifiers((CertificateToken)certToken)));
        xmlCert.setSelfSigned(certToken.isSelfSigned());
        xmlCert.setTrusted(certToken.isTrusted());
        xmlCert.setInfo(this.getXmlInfo(certToken.getValidationInfo()));
        Set revocationTokens = certToken.getRevocationTokens();
        if (Utils.isCollectionNotEmpty((Collection)revocationTokens)) {
            for (RevocationToken revocationToken : revocationTokens) {
                String xmlId = Utils.toHex((byte[])certToken.getDigest(DigestAlgorithm.SHA256)) + Utils.toHex((byte[])revocationToken.getDigest(DigestAlgorithm.SHA256));
                xmlCert.getRevocations().add(this.getXmlRevocation(revocationToken, xmlId, usedDigestAlgorithms));
            }
        }
        xmlCert.setTrustedServiceProviders(this.getXmlTrustedServiceProviders(certToken));
        return xmlCert;
    }

    private List<XmlOID> getXmlOids(List<String> oidList) {
        ArrayList<XmlOID> result = new ArrayList<XmlOID>();
        for (String oid : oidList) {
            XmlOID xmlOID = new XmlOID();
            xmlOID.setValue(oid);
            xmlOID.setDescription(OidRepository.getDescription(oid));
            result.add(xmlOID);
        }
        return result;
    }

    private List<XmlTrustedServiceProvider> getXmlTrustedServiceProviders(CertificateToken certToken) {
        ArrayList<XmlTrustedServiceProvider> result = new ArrayList<XmlTrustedServiceProvider>();
        Set<ServiceInfo> services = this.getLinkedTrustedServices(certToken);
        Map<String, List<ServiceInfo>> servicesByProviders = this.classifyByServiceProvider(services);
        for (List<ServiceInfo> serviceByProvider : servicesByProviders.values()) {
            ServiceInfo first = serviceByProvider.get(0);
            XmlTrustedServiceProvider serviceProvider = new XmlTrustedServiceProvider();
            serviceProvider.setCountryCode(first.getTlCountryCode());
            serviceProvider.setTSPName(first.getTspName());
            serviceProvider.setTSPServiceName(first.getServiceName());
            serviceProvider.setTrustedServices(this.getXmlTrustedServices(serviceByProvider, certToken));
            result.add(serviceProvider);
        }
        return Collections.unmodifiableList(result);
    }

    private List<XmlTrustedService> getXmlTrustedServices(List<ServiceInfo> serviceInfos, CertificateToken certToken) {
        ArrayList<XmlTrustedService> result = new ArrayList<XmlTrustedService>();
        for (ServiceInfo serviceInfo : serviceInfos) {
            List serviceStatusAfterOfEqualsCertIssuance = serviceInfo.getStatus().getAfter(certToken.getNotBefore());
            if (!Utils.isCollectionNotEmpty((Collection)serviceStatusAfterOfEqualsCertIssuance)) continue;
            for (ServiceInfoStatus serviceInfoStatus : serviceStatusAfterOfEqualsCertIssuance) {
                List serviceSupplyPoints;
                List additionalServiceInfoUris;
                XmlTrustedService trustedService = new XmlTrustedService();
                trustedService.setServiceType(serviceInfoStatus.getType());
                trustedService.setStatus(serviceInfoStatus.getStatus());
                trustedService.setStartDate(serviceInfoStatus.getStartDate());
                trustedService.setEndDate(serviceInfoStatus.getEndDate());
                List<String> qualifiers = this.getQualifiers(serviceInfoStatus, certToken);
                if (Utils.isCollectionNotEmpty(qualifiers)) {
                    trustedService.setCapturedQualifiers(qualifiers);
                }
                if (Utils.isCollectionNotEmpty((Collection)(additionalServiceInfoUris = serviceInfoStatus.getAdditionalServiceInfoUris()))) {
                    trustedService.setAdditionalServiceInfoUris(additionalServiceInfoUris);
                }
                if (Utils.isCollectionNotEmpty((Collection)(serviceSupplyPoints = serviceInfoStatus.getServiceSupplyPoints()))) {
                    trustedService.setServiceSupplyPoints(serviceSupplyPoints);
                }
                trustedService.setExpiredCertsRevocationInfo(serviceInfoStatus.getExpiredCertsRevocationInfo());
                result.add(trustedService);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private Map<String, List<ServiceInfo>> classifyByServiceProvider(Set<ServiceInfo> services) {
        HashMap<String, List<ServiceInfo>> servicesByProviders = new HashMap<String, List<ServiceInfo>>();
        if (Utils.isCollectionNotEmpty(services)) {
            for (ServiceInfo serviceInfo : services) {
                String tradeName = serviceInfo.getTspTradeName();
                ArrayList<ServiceInfo> servicesByProvider = (ArrayList<ServiceInfo>)servicesByProviders.get(tradeName);
                if (servicesByProvider == null) {
                    servicesByProvider = new ArrayList<ServiceInfo>();
                    servicesByProviders.put(tradeName, servicesByProvider);
                }
                servicesByProvider.add(serviceInfo);
            }
        }
        return servicesByProviders;
    }

    private Set<ServiceInfo> getLinkedTrustedServices(CertificateToken certToken) {
        Set services = null;
        if (certToken.isTrusted()) {
            services = certToken.getAssociatedTSPS();
        } else {
            CertificateToken trustAnchor = certToken.getTrustAnchor();
            if (trustAnchor != null) {
                services = trustAnchor.getAssociatedTSPS();
            }
        }
        return services;
    }

    private List<String> getQualifiers(ServiceInfoStatus serviceInfoStatus, CertificateToken certificateToken) {
        LOG.trace("--> GET_QUALIFIERS()");
        ArrayList<String> list = new ArrayList<String>();
        Map qualifiersAndConditions = serviceInfoStatus.getQualifiersAndConditions();
        block0: for (Map.Entry conditionEntry : qualifiersAndConditions.entrySet()) {
            List conditions = (List)conditionEntry.getValue();
            LOG.trace("  --> " + conditions);
            for (Condition condition : conditions) {
                if (!condition.check(certificateToken)) continue;
                LOG.trace("    --> CONDITION TRUE / " + (String)conditionEntry.getKey());
                list.add((String)conditionEntry.getKey());
                continue block0;
            }
        }
        return list;
    }

    private XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(DigestAlgorithm digestAlgo, String digestValue) {
        XmlDigestAlgoAndValue xmlDigestAlgAndValue = new XmlDigestAlgoAndValue();
        xmlDigestAlgAndValue.setDigestMethod(digestAlgo == null ? "" : digestAlgo.getName());
        xmlDigestAlgAndValue.setDigestValue(digestValue);
        return xmlDigestAlgAndValue;
    }
}

