/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.crl;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.client.crl.CachedCRL;
import eu.europa.esig.dss.client.crl.OnlineCRLSource;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.crl.CRLUtils;
import eu.europa.esig.dss.x509.crl.CRLValidity;
import java.security.cert.X509CRL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheCRLSource
implements CRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheCRLSource.class);
    public static final String SQL_INIT_CHECK_EXISTENCE = "SELECT COUNT(*) FROM CACHED_CRL";
    public static final String SQL_INIT_CREATE_TABLE = "CREATE TABLE CACHED_CRL (ID CHAR(40), DATA LONGVARBINARY)";
    public static final String SQL_FIND_QUERY = "SELECT * FROM CACHED_CRL WHERE ID = ?";
    public static final String SQL_FIND_QUERY_ID = "ID";
    public static final String SQL_FIND_QUERY_DATA = "DATA";
    public static final String SQL_FIND_INSERT = "INSERT INTO CACHED_CRL (ID, DATA) VALUES (?, ?)";
    public static final String SQL_FIND_UPDATE = "UPDATE CACHED_CRL SET DATA = ? WHERE ID = ?";
    private OnlineCRLSource cachedSource;
    private DataSource dataSource;
    private String sqlInitCheckExistence = "SELECT COUNT(*) FROM CACHED_CRL";
    private String sqlInitCreateTable = "CREATE TABLE CACHED_CRL (ID CHAR(40), DATA LONGVARBINARY)";
    private String sqlFindQuery = "SELECT * FROM CACHED_CRL WHERE ID = ?";
    private String sqlFindQueryId = "ID";
    private String sqlFindQueryData = "DATA";
    private String sqlFindInsert = "INSERT INTO CACHED_CRL (ID, DATA) VALUES (?, ?)";
    private String sqlFindUpdate = "UPDATE CACHED_CRL SET DATA = ? WHERE ID = ?";

    public CRLToken findCrl(CertificateToken certificateToken) throws DSSException {
        if (certificateToken == null) {
            return null;
        }
        CertificateToken issuerToken = certificateToken.getIssuerToken();
        if (issuerToken == null) {
            return null;
        }
        List<String> crlUrls = this.cachedSource.getCrlUrl(certificateToken);
        if (CollectionUtils.isEmpty(crlUrls)) {
            return null;
        }
        String crlUrl = crlUrls.get(0);
        LOG.info("CRL's URL for " + certificateToken.getAbbreviation() + " : " + crlUrl);
        try {
            CRLToken crlToken;
            X509CRL x509Crl;
            String key = DSSUtils.getSHA1Digest((String)crlUrl);
            CachedCRL dbCrl = this.findCrlInDB(key);
            if (dbCrl != null && (x509Crl = DSSUtils.loadCRL((byte[])dbCrl.getCrl())).getNextUpdate().after(new Date())) {
                LOG.debug("CRL in cache");
                CRLValidity crlValidity = CRLUtils.isValidCRL((X509CRL)x509Crl, (CertificateToken)issuerToken);
                CRLToken crlToken2 = new CRLToken(certificateToken, crlValidity);
                crlToken2.setSourceURL(crlUrl);
                if (crlToken2.isValid()) {
                    return crlToken2;
                }
            }
            if ((crlToken = this.cachedSource.findCrl(certificateToken)) != null && crlToken.isValid()) {
                if (dbCrl == null) {
                    LOG.info("CRL not in cache");
                    this.insertCrlInDb(key, crlToken.getEncoded());
                } else {
                    LOG.debug("CRL expired");
                    this.updateCrlInDb(key, crlToken.getEncoded());
                }
            }
            return crlToken;
        }
        catch (SQLException e) {
            LOG.info("Error with the cache data store");
            return null;
        }
    }

    public void setCachedSource(OnlineCRLSource cachedSource) {
        this.cachedSource = cachedSource;
    }

    private void initDao() throws Exception {
        if (!this.tableExists()) {
            this.createTable();
        }
    }

    private void createTable() throws SQLException {
        Connection c = null;
        Statement s = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.createStatement();
            s.executeQuery(this.sqlInitCreateTable);
            c.commit();
        }
        finally {
            this.closeQuietly(c, s, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists() {
        boolean tableExists;
        Connection c = null;
        Statement s = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.createStatement();
            s.executeQuery(this.sqlInitCheckExistence);
            tableExists = true;
        }
        catch (SQLException e) {
            tableExists = false;
        }
        finally {
            this.closeQuietly(c, s, null);
        }
        return tableExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedCRL findCrlInDB(String key) throws SQLException {
        Connection c = null;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.prepareStatement(this.sqlFindQuery);
            s.setString(1, key);
            rs = s.executeQuery();
            if (rs.next()) {
                CachedCRL cached = new CachedCRL();
                cached.setKey(rs.getString(this.sqlFindQueryId));
                cached.setCrl(rs.getBytes(this.sqlFindQueryData));
                CachedCRL cachedCRL = cached;
                this.closeQuietly(c, s, rs);
                return cachedCRL;
            }
            this.closeQuietly(c, s, rs);
        }
        catch (Throwable throwable) {
            this.closeQuietly(c, s, rs);
            throw throwable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCrlInDb(String key, byte[] encoded) throws SQLException {
        Connection c = null;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.prepareStatement(this.sqlFindInsert);
            s.setString(1, key);
            s.setBytes(2, encoded);
            s.executeUpdate();
            this.closeQuietly(c, s, rs);
        }
        catch (Throwable throwable) {
            this.closeQuietly(c, s, rs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCrlInDb(String key, byte[] encoded) throws SQLException {
        Connection c = null;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            c = this.getDataSource().getConnection();
            s = c.prepareStatement(this.sqlFindUpdate);
            s.setBytes(1, encoded);
            s.setString(2, key);
            s.executeUpdate();
            this.closeQuietly(c, s, rs);
        }
        catch (Throwable throwable) {
            this.closeQuietly(c, s, rs);
            throw throwable;
        }
    }

    private DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        this.initDao();
    }

    public String getSqlInitCheckExistence() {
        return this.sqlInitCheckExistence;
    }

    public void setSqlInitCheckExistence(String sqlInitCheckExistence) {
        this.sqlInitCheckExistence = sqlInitCheckExistence;
    }

    public String getSqlInitCreateTable() {
        return this.sqlInitCreateTable;
    }

    public void setSqlInitCreateTable(String sqlInitCreateTable) {
        this.sqlInitCreateTable = sqlInitCreateTable;
    }

    public String getSqlFindQuery() {
        return this.sqlFindQuery;
    }

    public void setSqlFindQuery(String sqlFindQuery) {
        this.sqlFindQuery = sqlFindQuery;
    }

    public String getSqlFindQueryId() {
        return this.sqlFindQueryId;
    }

    public void setSqlFindQueryId(String sqlFindQueryId) {
        this.sqlFindQueryId = sqlFindQueryId;
    }

    public String getSqlFindQueryData() {
        return this.sqlFindQueryData;
    }

    public void setSqlFindQueryData(String sqlFindQueryData) {
        this.sqlFindQueryData = sqlFindQueryData;
    }

    public String getSqlFindInsert() {
        return this.sqlFindInsert;
    }

    public void setSqlFindInsert(String sqlFindInsert) {
        this.sqlFindInsert = sqlFindInsert;
    }

    public String getSqlFindUpdate() {
        return this.sqlFindUpdate;
    }

    public void setSqlFindUpdate(String sqlFindUpdate) {
        this.sqlFindUpdate = sqlFindUpdate;
    }

    private void closeQuietly(Connection c, Statement s, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (s != null) {
                s.close();
            }
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

