/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.crl;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.client.http.Protocol;
import eu.europa.esig.dss.client.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.crl.CRLUtils;
import eu.europa.esig.dss.x509.crl.CRLValidity;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineCRLSource
implements CRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(OnlineCRLSource.class);
    private Protocol preferredProtocol;
    private DataLoader dataLoader;

    public OnlineCRLSource() {
        this.dataLoader = new CommonsDataLoader();
        LOG.trace("+OnlineCRLSource with the default data loader.");
    }

    public OnlineCRLSource(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
        LOG.trace("+OnlineCRLSource with the specific data loader.");
    }

    public void setPreferredProtocol(Protocol preferredProtocol) {
        this.preferredProtocol = preferredProtocol;
    }

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public CRLToken findCrl(CertificateToken certificateToken) throws DSSException {
        X509CRL crl;
        if (certificateToken == null) {
            return null;
        }
        CertificateToken issuerToken = certificateToken.getIssuerToken();
        if (issuerToken == null) {
            return null;
        }
        List<String> crlUrls = this.getCrlUrl(certificateToken);
        LOG.info("CRL's URL for " + certificateToken.getAbbreviation() + " : " + crlUrls);
        if (CollectionUtils.isEmpty(crlUrls)) {
            return null;
        }
        DataLoader.DataAndUrl dataAndUrl = this.downloadCrl(crlUrls);
        if (dataAndUrl == null) {
            return null;
        }
        try {
            crl = DSSUtils.loadCRL((byte[])dataAndUrl.data);
        }
        catch (Exception e) {
            LOG.warn("Unable to load the CRL (url:" + dataAndUrl.urlString + ") : " + e.getMessage(), (Throwable)e);
            return null;
        }
        CRLValidity crlValidity = CRLUtils.isValidCRL((X509CRL)crl, (CertificateToken)issuerToken);
        CRLToken crlToken = new CRLToken(certificateToken, crlValidity);
        crlToken.setSourceURL(dataAndUrl.urlString);
        crlToken.setAvailable(true);
        return crlToken;
    }

    private DataLoader.DataAndUrl downloadCrl(List<String> downloadUrls) {
        if (CollectionUtils.isEmpty(downloadUrls)) {
            return null;
        }
        try {
            DataLoader.DataAndUrl dataAndUrl = this.dataLoader.get(downloadUrls);
            return dataAndUrl;
        }
        catch (DSSException e) {
            LOG.warn("", (Throwable)e);
            return null;
        }
    }

    public List<String> getCrlUrl(CertificateToken certificateToken) throws DSSException {
        String id = Extension.cRLDistributionPoints.getId();
        byte[] crlDistributionPointsBytes = certificateToken.getCertificate().getExtensionValue(id);
        if (null == crlDistributionPointsBytes) {
            return null;
        }
        try {
            DistributionPoint[] distributionPoints;
            ArrayList<String> urls = new ArrayList<String>();
            ASN1Sequence asn1Sequence = DSSASN1Utils.getAsn1SequenceFromDerOctetString((byte[])crlDistributionPointsBytes);
            CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)asn1Sequence);
            for (DistributionPoint distributionPoint : distributionPoints = distPoint.getDistributionPoints()) {
                GeneralName[] names;
                DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
                if (0 != distributionPointName.getType()) continue;
                GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
                for (GeneralName name : names = generalNames.getNames()) {
                    if (name.getTagNo() != 6) {
                        LOG.debug("Not a uniform resource identifier");
                        continue;
                    }
                    ASN1Primitive asn1Primitive = name.toASN1Primitive();
                    if (asn1Primitive instanceof DERTaggedObject) {
                        DERTaggedObject taggedObject = (DERTaggedObject)asn1Primitive;
                        asn1Primitive = taggedObject.getObject();
                    }
                    DERIA5String derStr = DERIA5String.getInstance((Object)asn1Primitive);
                    String urlStr = derStr.getString();
                    urls.add(urlStr);
                }
            }
            this.prioritize(urls);
            return urls;
        }
        catch (Exception e) {
            if (e instanceof DSSException) {
                throw (DSSException)((Object)e);
            }
            throw new DSSException((Throwable)e);
        }
    }

    private void prioritize(List<String> urls) {
        if (this.preferredProtocol != null) {
            ArrayList<String> priorityUrls = new ArrayList<String>();
            for (String url : urls) {
                if (!this.preferredProtocol.isTheSame(url)) continue;
                priorityUrls.add(url);
            }
            urls.removeAll(priorityUrls);
            for (int ii = priorityUrls.size() - 1; ii >= 0; --ii) {
                urls.add(0, (String)priorityUrls.get(ii));
            }
        }
    }
}

