/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http.commons;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.client.http.Protocol;
import eu.europa.esig.dss.client.http.commons.AcceptAllTrustManager;
import eu.europa.esig.dss.client.http.commons.DSSNotifier;
import eu.europa.esig.dss.client.http.commons.DefaultKeyManager;
import eu.europa.esig.dss.client.http.commons.DefaultTrustManager;
import eu.europa.esig.dss.client.http.proxy.ProxyPreferenceManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsDataLoader
implements DataLoader,
DSSNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(CommonsDataLoader.class);
    public static final int TIMEOUT_CONNECTION = 6000;
    public static final int TIMEOUT_SOCKET = 6000;
    public static final int CONNECTIONS_MAX_TOTAL = 20;
    public static final int CONNECTIONS_MAX_PER_ROUTE = 2;
    public static final String CONTENT_TYPE = "Content-Type";
    protected String contentType;
    private ProxyPreferenceManager proxyPreferenceManager;
    private int timeoutConnection = 6000;
    private int timeoutSocket = 6000;
    private int connectionsMaxTotal = 20;
    private int connectionsMaxPerRoute = 2;
    private boolean redirectsEnabled = true;
    private final Map<HttpHost, UsernamePasswordCredentials> authenticationMap = new HashMap<HttpHost, UsernamePasswordCredentials>();
    private boolean updated;
    private String sslKeystorePath;
    private String sslKeystoreType = KeyStore.getDefaultType();
    private String sslKeystorePassword = "";
    private String sslTruststorePath;
    private String sslTruststoreType = KeyStore.getDefaultType();
    private String sslTruststorePassword = "";

    public CommonsDataLoader() {
        this(null);
    }

    public CommonsDataLoader(String contentType) {
        this.contentType = contentType;
    }

    private HttpClientConnectionManager getConnectionManager() throws DSSException {
        RegistryBuilder<ConnectionSocketFactory> socketFactoryRegistryBuilder = RegistryBuilder.create();
        socketFactoryRegistryBuilder = this.setConnectionManagerSchemeHttp(socketFactoryRegistryBuilder);
        socketFactoryRegistryBuilder = this.setConnectionManagerSchemeHttps(socketFactoryRegistryBuilder);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistryBuilder.build());
        connectionManager.setMaxTotal(this.getConnectionsMaxTotal());
        connectionManager.setDefaultMaxPerRoute(this.getConnectionsMaxPerRoute());
        LOG.debug("PoolingHttpClientConnectionManager: max total: " + connectionManager.getMaxTotal());
        LOG.debug("PoolingHttpClientConnectionManager: max per route: " + connectionManager.getDefaultMaxPerRoute());
        return connectionManager;
    }

    private RegistryBuilder<ConnectionSocketFactory> setConnectionManagerSchemeHttp(RegistryBuilder<ConnectionSocketFactory> socketFactoryRegistryBuilder) {
        return socketFactoryRegistryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
    }

    private RegistryBuilder<ConnectionSocketFactory> setConnectionManagerSchemeHttps(RegistryBuilder<ConnectionSocketFactory> socketFactoryRegistryBuilder) throws DSSException {
        RegistryBuilder registryBuilder;
        FileInputStream fis = null;
        FileInputStream trustStoreIs = null;
        try {
            SSLContext sslContext = null;
            if (StringUtils.isEmpty((String)this.sslKeystorePath)) {
                LOG.debug("Use default SSL configuration");
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(new KeyManager[0], new TrustManager[]{new AcceptAllTrustManager()}, new SecureRandom());
                SSLContext.setDefault(sslContext);
            } else {
                LOG.debug("Use provided info for SSL");
                fis = new FileInputStream(new File(this.sslKeystorePath));
                trustStoreIs = new FileInputStream(new File(this.sslTruststorePath));
                sslContext = SSLContext.getInstance("TLS");
                DefaultKeyManager dkm = new DefaultKeyManager(fis, this.sslKeystoreType, this.sslKeystorePassword);
                sslContext.init(new KeyManager[]{dkm}, new TrustManager[]{new DefaultTrustManager(trustStoreIs, this.sslTruststoreType, this.sslTruststorePassword)}, null);
            }
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext);
            registryBuilder = socketFactoryRegistryBuilder.register("https", (Object)sslConnectionSocketFactory);
        }
        catch (Exception e) {
            try {
                throw new DSSException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly(trustStoreIs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((InputStream)trustStoreIs);
        return registryBuilder;
    }

    protected synchronized CloseableHttpClient getHttpClient(String url) throws DSSException {
        if (LOG.isTraceEnabled() && this.updated) {
            LOG.trace(">>> Proxy preferences updated");
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder = this.configCredentials(httpClientBuilder, url);
        RequestConfig.Builder custom = RequestConfig.custom();
        custom.setSocketTimeout(this.timeoutSocket);
        custom.setConnectTimeout(this.timeoutConnection);
        custom.setRedirectsEnabled(this.redirectsEnabled);
        RequestConfig requestConfig = custom.build();
        httpClientBuilder = httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager(this.getConnectionManager());
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return httpClient;
    }

    private HttpClientBuilder configCredentials(HttpClientBuilder httpClientBuilder, String url) throws DSSException {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        for (Map.Entry<HttpHost, UsernamePasswordCredentials> entry : this.authenticationMap.entrySet()) {
            HttpHost httpHost = entry.getKey();
            UsernamePasswordCredentials usernamePasswordCredentials = entry.getValue();
            AuthScope authscope = new AuthScope(httpHost.getHostName(), httpHost.getPort());
            credentialsProvider.setCredentials(authscope, (Credentials)usernamePasswordCredentials);
        }
        httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        httpClientBuilder = this.configureProxy(httpClientBuilder, (CredentialsProvider)credentialsProvider, url);
        return httpClientBuilder;
    }

    private HttpClientBuilder configureProxy(HttpClientBuilder httpClientBuilder, CredentialsProvider credentialsProvider, String url) throws DSSException {
        if (this.proxyPreferenceManager == null) {
            return httpClientBuilder;
        }
        try {
            Long port;
            boolean proxyHTTP;
            String protocol = new URL(url).getProtocol();
            boolean proxyHTTPS = Protocol.isHttps((String)protocol) && this.proxyPreferenceManager.isHttpsEnabled();
            boolean bl = proxyHTTP = Protocol.isHttp((String)protocol) && this.proxyPreferenceManager.isHttpEnabled();
            if (!proxyHTTPS && !proxyHTTP) {
                return httpClientBuilder;
            }
            String proxyHost = null;
            int proxyPort = 0;
            String proxyUser = null;
            String proxyPassword = null;
            String proxyExcludedHosts = null;
            if (proxyHTTPS) {
                LOG.debug("Use proxy https parameters");
                port = this.proxyPreferenceManager.getHttpsPort();
                proxyPort = port != null ? port.intValue() : 0;
                proxyHost = this.proxyPreferenceManager.getHttpsHost();
                proxyUser = this.proxyPreferenceManager.getHttpsUser();
                proxyPassword = this.proxyPreferenceManager.getHttpsPassword();
                proxyExcludedHosts = this.proxyPreferenceManager.getHttpsExcludedHosts();
            } else if (proxyHTTP) {
                LOG.debug("Use proxy http parameters");
                port = this.proxyPreferenceManager.getHttpPort();
                proxyPort = port != null ? port.intValue() : 0;
                proxyHost = this.proxyPreferenceManager.getHttpHost();
                proxyUser = this.proxyPreferenceManager.getHttpUser();
                proxyPassword = this.proxyPreferenceManager.getHttpPassword();
                proxyExcludedHosts = this.proxyPreferenceManager.getHttpExcludedHosts();
            }
            if (StringUtils.isNotEmpty(proxyUser) && StringUtils.isNotEmpty(proxyPassword)) {
                AuthScope proxyAuth = new AuthScope(proxyHost, proxyPort);
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                credentialsProvider.setCredentials(proxyAuth, (Credentials)proxyCredentials);
            }
            LOG.debug("proxy host/port: " + proxyHost + ":" + proxyPort);
            HttpHost proxy = new HttpHost(proxyHost, proxyPort, Protocol.HTTP.getName());
            if (StringUtils.isNotEmpty((String)proxyExcludedHosts)) {
                final String[] hosts = proxyExcludedHosts.split("[,; ]");
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy){

                    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
                        String hostname;
                        String string = hostname = host != null ? host.getHostName() : null;
                        if (hosts != null && hostname != null) {
                            for (String h : hosts) {
                                if (!hostname.equalsIgnoreCase(h)) continue;
                                return new HttpRoute(host);
                            }
                        }
                        return super.determineRoute(host, request, context);
                    }
                };
                httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            }
            HttpClientBuilder httpClientBuilder1 = httpClientBuilder.setProxy(proxy);
            this.updated = false;
            return httpClientBuilder1;
        }
        catch (MalformedURLException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public byte[] get(String urlString) {
        if (Protocol.isFileUrl((String)urlString)) {
            return this.fileGet(urlString);
        }
        if (Protocol.isHttpUrl((String)urlString)) {
            return this.httpGet(urlString);
        }
        if (Protocol.isFtpUrl((String)urlString)) {
            return this.ftpGet(urlString);
        }
        if (Protocol.isLdapUrl((String)urlString)) {
            return this.ldapGet(urlString);
        }
        LOG.warn("DSS framework only supports HTTP, HTTPS, FTP and LDAP CRL's urlString.");
        return this.httpGet(urlString);
    }

    public DataLoader.DataAndUrl get(List<String> urlStrings) {
        int numberOfUrls = urlStrings.size();
        int ii = 0;
        for (String urlString : urlStrings) {
            try {
                ++ii;
                byte[] bytes = this.get(urlString);
                if (bytes == null) continue;
                return new DataLoader.DataAndUrl(bytes, urlString);
            }
            catch (Exception e) {
                if (ii == numberOfUrls) {
                    if (e instanceof DSSException) {
                        throw (DSSException)((Object)e);
                    }
                    throw new DSSException((Throwable)e);
                }
                LOG.warn("Impossible to obtain data using {}", (Object)urlString, (Object)e);
            }
        }
        return null;
    }

    public byte[] get(String url, boolean refresh) {
        return this.get(url);
    }

    private byte[] fileGet(String urlString) {
        try {
            return DSSUtils.toByteArray((InputStream)new URL(urlString).openStream());
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private byte[] ldapGet(String urlString) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", urlString);
        try {
            InitialDirContext ctx;
            Attributes attributes;
            String attributeName;
            String ldapParams = StringUtils.substringAfter((String)urlString, (String)"?");
            StringTokenizer tokenizer = new StringTokenizer(ldapParams, "?");
            String string = attributeName = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (StringUtils.isEmpty((String)attributeName)) {
                attributeName = "certificateRevocationList;binary";
            }
            if ((attributes = (ctx = new InitialDirContext(env)).getAttributes("", new String[]{attributeName})) == null || attributes.size() < 1) {
                LOG.warn("Cannot download CRL from: " + urlString + ", no attributes with name: " + attributeName + " returned");
            } else {
                Attribute attribute = attributes.getAll().next();
                byte[] ldapBytes = (byte[])attribute.get();
                if (ArrayUtils.isNotEmpty((byte[])ldapBytes)) {
                    return ldapBytes;
                }
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] ftpGet(String urlString) {
        byte[] byArray;
        InputStream inputStream = null;
        try {
            URL url = new URL(urlString);
            inputStream = url.openStream();
            byArray = DSSUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            try {
                LOG.warn(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return null;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] httpGet(String url) {
        byte[] byArray;
        HttpGet httpRequest = null;
        HttpResponse httpResponse = null;
        CloseableHttpClient client = null;
        try {
            byte[] returnedBytes;
            URI uri = new URI(url.trim());
            httpRequest = new HttpGet(uri);
            if (this.contentType != null) {
                httpRequest.setHeader(CONTENT_TYPE, this.contentType);
            }
            client = this.getHttpClient(url);
            httpResponse = this.getHttpResponse(client, (HttpUriRequest)httpRequest, url);
            byArray = returnedBytes = this.readHttpResponse(url, httpResponse);
        }
        catch (URISyntaxException e) {
            try {
                throw new DSSException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (httpRequest != null) {
                        httpRequest.releaseConnection();
                    }
                    if (httpResponse == null) throw throwable;
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    throw throwable;
                }
                finally {
                    this.closeClient(client);
                }
            }
        }
        try {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
            if (httpResponse == null) return byArray;
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            return byArray;
        }
        finally {
            this.closeClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] post(String url, byte[] content) throws DSSException {
        byte[] byArray;
        LOG.debug("Fetching data via POST from url " + url);
        HttpPost httpRequest = null;
        HttpResponse httpResponse = null;
        CloseableHttpClient client = null;
        try {
            byte[] returnedBytes;
            URI uri = URI.create(url.trim());
            httpRequest = new HttpPost(uri);
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            InputStreamEntity httpEntity = new InputStreamEntity((InputStream)bis, (long)content.length);
            BufferedHttpEntity requestEntity = new BufferedHttpEntity((HttpEntity)httpEntity);
            httpRequest.setEntity((HttpEntity)requestEntity);
            if (this.contentType != null) {
                httpRequest.setHeader(CONTENT_TYPE, this.contentType);
            }
            client = this.getHttpClient(url);
            httpResponse = this.getHttpResponse(client, (HttpUriRequest)httpRequest, url);
            byArray = returnedBytes = this.readHttpResponse(url, httpResponse);
        }
        catch (IOException e) {
            try {
                throw new DSSException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (httpRequest != null) {
                        httpRequest.releaseConnection();
                    }
                    if (httpResponse == null) throw throwable;
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    throw throwable;
                }
                finally {
                    this.closeClient(client);
                }
            }
        }
        try {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
            if (httpResponse == null) return byArray;
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            return byArray;
        }
        finally {
            this.closeClient(client);
        }
    }

    void closeClient(CloseableHttpClient httpClient) {
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (Exception ex) {
                LOG.warn("Cound not close client", (Throwable)ex);
            }
            finally {
                httpClient = null;
            }
        }
    }

    protected HttpResponse getHttpResponse(CloseableHttpClient client, HttpUriRequest httpRequest, String url) throws DSSException {
        String host = httpRequest.getURI().getHost();
        int port = httpRequest.getURI().getPort();
        String scheme = httpRequest.getURI().getScheme();
        HttpHost targetHost = new HttpHost(host, port, scheme);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        try {
            CloseableHttpResponse response = client.execute(targetHost, (HttpRequest)httpRequest, (HttpContext)localContext);
            return response;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    protected byte[] readHttpResponse(String url, HttpResponse httpResponse) throws DSSException {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (LOG.isDebugEnabled()) {
            LOG.debug(url + " status code is " + statusCode + " - " + (statusCode == 200 ? "OK" : "NOK"));
        }
        if (statusCode != 200) {
            LOG.warn("No content available via url: " + url);
            return null;
        }
        HttpEntity responseEntity = httpResponse.getEntity();
        if (responseEntity == null) {
            LOG.warn("No message entity for this response - will use nothing: " + url);
            return null;
        }
        byte[] content = this.getContent(responseEntity);
        return content;
    }

    protected byte[] getContent(HttpEntity responseEntity) throws DSSException {
        InputStream content = null;
        try {
            byte[] bytes;
            content = responseEntity.getContent();
            byte[] byArray = bytes = DSSUtils.toByteArray((InputStream)content);
            return byArray;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    public int getTimeoutConnection() {
        return this.timeoutConnection;
    }

    public void setTimeoutConnection(int timeoutConnection) {
        this.timeoutConnection = timeoutConnection;
    }

    public int getTimeoutSocket() {
        return this.timeoutSocket;
    }

    public void setTimeoutSocket(int timeoutSocket) {
        this.timeoutSocket = timeoutSocket;
    }

    public int getConnectionsMaxTotal() {
        return this.connectionsMaxTotal;
    }

    public void setConnectionsMaxTotal(int connectionsMaxTotal) {
        this.connectionsMaxTotal = connectionsMaxTotal;
    }

    public int getConnectionsMaxPerRoute() {
        return this.connectionsMaxPerRoute;
    }

    public void setConnectionsMaxPerRoute(int connectionsMaxPerRoute) {
        this.connectionsMaxPerRoute = connectionsMaxPerRoute;
    }

    public boolean isRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.redirectsEnabled = redirectsEnabled;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ProxyPreferenceManager getProxyPreferenceManager() {
        return this.proxyPreferenceManager;
    }

    public void setProxyPreferenceManager(ProxyPreferenceManager proxyPreferenceManager) {
        this.proxyPreferenceManager = proxyPreferenceManager;
        if (proxyPreferenceManager != null) {
            proxyPreferenceManager.addNotifier(this);
            if (LOG.isTraceEnabled()) {
                LOG.trace(">>> SET: " + proxyPreferenceManager);
            }
        }
    }

    public void setSslKeystorePath(String sslKeystorePath) {
        this.sslKeystorePath = sslKeystorePath;
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public void setSslTruststorePath(String sslTruststorePath) {
        this.sslTruststorePath = sslTruststorePath;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public void setSslTruststoreType(String sslTruststoreType) {
        this.sslTruststoreType = sslTruststoreType;
    }

    public CommonsDataLoader addAuthentication(String host, int port, String scheme, String login, String password) {
        HttpHost httpHost = new HttpHost(host, port, scheme);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(login, password);
        this.authenticationMap.put(httpHost, credentials);
        return this;
    }

    public void propagateAuthentication(CommonsDataLoader commonsDataLoader) {
        for (Map.Entry<HttpHost, UsernamePasswordCredentials> credentialsEntry : this.authenticationMap.entrySet()) {
            HttpHost httpHost = credentialsEntry.getKey();
            UsernamePasswordCredentials credentials = credentialsEntry.getValue();
            commonsDataLoader.addAuthentication(httpHost.getHostName(), httpHost.getPort(), httpHost.getSchemeName(), credentials.getUserName(), credentials.getPassword());
        }
    }

    @Override
    public void update() {
        this.updated = true;
    }
}

