/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http.commons;

import eu.europa.esig.dss.DSSCannotFetchDataException;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.ResourceLoader;
import eu.europa.esig.dss.client.http.Protocol;
import eu.europa.esig.dss.client.http.commons.CommonsDataLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheDataLoader
extends CommonsDataLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FileCacheDataLoader.class);
    private File fileCacheDirectory = new File(System.getProperty("java.io.tmpdir"));
    private ResourceLoader resourceLoader = new ResourceLoader();
    private List<String> toBeLoaded;
    private List<String> toIgnored;
    private Long cacheExpirationTime;

    public void setFileCacheDirectory(File fileCacheDirectory) {
        this.fileCacheDirectory = fileCacheDirectory;
        this.fileCacheDirectory.mkdirs();
    }

    public void setCacheExpirationTime(long cacheExpirationTimeInMilliseconds) {
        this.cacheExpirationTime = cacheExpirationTimeInMilliseconds;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void addToBeLoaded(String url) {
        if (this.toBeLoaded == null) {
            this.toBeLoaded = new ArrayList<String>();
        }
        if (StringUtils.isNotBlank((String)url)) {
            this.toBeLoaded.add(url);
        }
    }

    public void addToBeIgnored(String urlString) {
        if (this.toIgnored == null) {
            this.toIgnored = new ArrayList<String>();
        }
        if (StringUtils.isNotBlank((String)urlString)) {
            String normalizedFileName = ResourceLoader.getNormalizedFileName((String)urlString);
            this.toIgnored.add(normalizedFileName);
        }
    }

    @Override
    public byte[] get(String url, boolean refresh) throws DSSCannotFetchDataException {
        byte[] bytes;
        if (this.toBeLoaded != null && !this.toBeLoaded.contains(url)) {
            return null;
        }
        String fileName = ResourceLoader.getNormalizedFileName((String)url);
        File file = this.getCacheFile(fileName);
        boolean fileExists = file.exists();
        boolean isCacheExpired = this.isCacheExpired(file);
        if (fileExists && !refresh && !isCacheExpired) {
            LOG.debug("Cached file was used");
            byte[] bytes2 = DSSUtils.toByteArray((File)file);
            return bytes2;
        }
        if (!fileExists) {
            LOG.debug("There is no cached file!");
        } else {
            LOG.debug("The refresh is forced!");
        }
        if (!this.isNetworkProtocol(url)) {
            String resourcePath = this.resourceLoader.getAbsoluteResourceFolder(url.trim());
            File fileResource = new File(resourcePath);
            bytes = DSSUtils.toByteArray((File)fileResource);
        } else {
            bytes = super.get(url);
        }
        if (bytes != null && bytes.length != 0) {
            File out = this.getCacheFile(fileName);
            DSSUtils.saveToFile((byte[])bytes, (File)out);
        }
        return bytes;
    }

    @Override
    public byte[] get(String url) throws DSSCannotFetchDataException {
        return this.get(url, false);
    }

    protected boolean isNetworkProtocol(String urlString) {
        String normalizedUrl = urlString.trim().toLowerCase();
        return Protocol.isHttpUrl((String)normalizedUrl) || Protocol.isLdapUrl((String)normalizedUrl) || Protocol.isFtpUrl((String)normalizedUrl);
    }

    private File getCacheFile(String fileName) {
        String trimmedFileName = fileName.trim();
        if (this.toIgnored != null && this.toIgnored.contains(trimmedFileName)) {
            throw new DSSException("Part of urls to ignore.");
        }
        LOG.debug("Cached file: " + this.fileCacheDirectory + "/" + trimmedFileName);
        File file = new File(this.fileCacheDirectory, trimmedFileName);
        return file;
    }

    public byte[] loadFileFromCache(String urlString) {
        String fileName = ResourceLoader.getNormalizedFileName((String)urlString);
        File file = this.getCacheFile(fileName);
        if (file.exists()) {
            byte[] bytes = DSSUtils.toByteArray((File)file);
            return bytes;
        }
        return null;
    }

    public void saveBytesInCache(String urlString, byte[] bytes) {
        String fileName = ResourceLoader.getNormalizedFileName((String)urlString);
        File out = this.getCacheFile(fileName);
        DSSUtils.saveToFile((byte[])bytes, (File)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] post(String urlString, byte[] content) throws DSSException {
        byte[] returnedBytes;
        String fileName = ResourceLoader.getNormalizedFileName((String)urlString);
        byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.MD5, (byte[])content);
        String digestHexEncoded = DSSUtils.toHex((byte[])digest);
        String cacheFileName = fileName + "." + digestHexEncoded;
        File file = this.getCacheFile(cacheFileName);
        if (file.exists()) {
            LOG.debug("Cached file was used");
            return DSSUtils.toByteArray((File)file);
        }
        LOG.debug("There is no cached file!");
        if (!this.isNetworkProtocol(urlString)) {
            String resourcePath = this.resourceLoader.getAbsoluteResourceFolder(urlString.trim());
            File fileResource = new File(resourcePath);
            return DSSUtils.toByteArray((File)fileResource);
        }
        HttpPost httpRequest = null;
        HttpResponse httpResponse = null;
        CloseableHttpClient client = null;
        try {
            URI uri = URI.create(urlString.trim());
            httpRequest = new HttpPost(uri);
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            InputStreamEntity httpEntity = new InputStreamEntity((InputStream)bis, (long)content.length);
            BufferedHttpEntity requestEntity = new BufferedHttpEntity((HttpEntity)httpEntity);
            httpRequest.setEntity((HttpEntity)requestEntity);
            if (this.contentType != null) {
                httpRequest.setHeader("Content-Type", this.contentType);
            }
            if ((returnedBytes = this.readHttpResponse(urlString, httpResponse = super.getHttpResponse(client = this.getHttpClient(urlString), (HttpUriRequest)httpRequest, urlString))).length != 0) {
                File cacheFile = this.getCacheFile(cacheFileName);
                DSSUtils.saveToFile((byte[])returnedBytes, (File)cacheFile);
            }
        }
        catch (IOException e) {
            try {
                throw new DSSException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (httpRequest != null) {
                        httpRequest.releaseConnection();
                    }
                    if (httpResponse == null) throw throwable;
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    throw throwable;
                }
                finally {
                    this.closeClient(client);
                }
            }
        }
        try {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
            if (httpResponse == null) return returnedBytes;
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            return returnedBytes;
        }
        finally {
            this.closeClient(client);
        }
    }

    private boolean isCacheExpired(File file) {
        if (this.cacheExpirationTime == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        long currentTime = new Date().getTime();
        if (file.lastModified() + this.cacheExpirationTime < currentTime) {
            LOG.debug("Cache is expired");
            return true;
        }
        return false;
    }
}

