/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http.proxy;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.client.http.proxy.ProxyDao;
import eu.europa.esig.dss.client.http.proxy.ProxyKey;
import eu.europa.esig.dss.client.http.proxy.ProxyPreference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFileDao
implements ProxyDao {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyFileDao.class);
    protected Map<ProxyKey, ProxyPreference> proxyPreferences = new HashMap<ProxyKey, ProxyPreference>();

    public ProxyFileDao(String proxyPreferencesResourcePath) {
        LOG.info(">>> ProxyFileDao: " + proxyPreferencesResourcePath);
        try {
            InputStream propertyInputStream = DSSUtils.getResource((String)proxyPreferencesResourcePath);
            Properties properties = new Properties();
            properties.load(propertyInputStream);
            for (Map.Entry<Object, Object> keySet : properties.entrySet()) {
                String key = (String)keySet.getKey();
                String value = (String)keySet.getValue();
                LOG.trace(key + "=" + (key.contains("password") ? "******" : value));
                ProxyKey proxyKey = ProxyKey.fromKey(key);
                if (proxyKey == null) continue;
                ProxyPreference proxyPreference = new ProxyPreference(proxyKey, value);
                this.proxyPreferences.put(proxyKey, proxyPreference);
            }
        }
        catch (IOException e) {
            throw new DSSException("Error when initialising ProxyFileDao", (Throwable)e);
        }
    }

    @Override
    public ProxyPreference get(ProxyKey proxyKey) {
        ProxyPreference proxyPreference = this.proxyPreferences.get((Object)proxyKey);
        return proxyPreference;
    }

    @Override
    public Collection<ProxyPreference> getAll() {
        ArrayList<ProxyPreference> proxyPreferenceList = new ArrayList<ProxyPreference>(this.proxyPreferences.values());
        return proxyPreferenceList;
    }

    @Override
    public void update(ProxyPreference proxyPreference) {
        this.proxyPreferences.put(proxyPreference.getProxyKey(), proxyPreference);
    }

    public String toString() {
        return "ProxyFileDao{proxyPreferences=" + this.proxyPreferences + '}';
    }
}

