/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http.proxy;

import eu.europa.esig.dss.client.http.proxy.ProxyDao;
import eu.europa.esig.dss.client.http.proxy.ProxyDaoException;
import eu.europa.esig.dss.client.http.proxy.ProxyKey;
import eu.europa.esig.dss.client.http.proxy.ProxyPreference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyJdbcDao
implements ProxyDao {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyJdbcDao.class);
    private DataSource dataSource;

    public ProxyJdbcDao() {
        LOG.info(">>> ProxyJdbcDao");
    }

    @Override
    public ProxyPreference get(ProxyKey proxyKey) {
        String sql = "select * from PROXY_PREFERENCES where PROXY_KEY = ?";
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            preparedStatement = connection.prepareStatement("select * from PROXY_PREFERENCES where PROXY_KEY = ?");
            preparedStatement.setString(1, proxyKey.getKeyName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ProxyPreference proxyPreference = new ProxyPreference();
                String proxyKeyString = resultSet.getString("PROXY_KEY");
                proxyPreference.setProxyKey(proxyKeyString);
                proxyPreference.setValue(resultSet.getString("PROXY_VALUE"));
                ProxyPreference proxyPreference2 = proxyPreference;
                return proxyPreference2;
            }
            ProxyPreference proxyPreference = null;
            return proxyPreference;
        }
        catch (SQLException e) {
            throw new ProxyDaoException(e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public Collection<ProxyPreference> getAll() {
        String sql = "select * from PROXY_PREFERENCES";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<ProxyPreference> proxyPreferences = new ArrayList<ProxyPreference>();
        try {
            connection = this.getDataSource().getConnection();
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                ProxyPreference pp = new ProxyPreference();
                pp.setProxyKey(rs.getString("PROXY_KEY"));
                pp.setValue(rs.getString("PROXY_VALUE"));
                proxyPreferences.add(pp);
            }
        }
        catch (SQLException e) {
            throw new ProxyDaoException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return proxyPreferences;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private DataSource getDataSource() {
        if (this.dataSource == null) {
            throw new IllegalStateException("You must set the datasource to use this class!");
        }
        return this.dataSource;
    }

    @Override
    public void update(ProxyPreference entity) {
        String sql = "update PROXY_PREFERENCES set PROXY_VALUE = ? where PROXY_KEY = ?";
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.getDataSource().getConnection();
            preparedStatement = connection.prepareStatement("update PROXY_PREFERENCES set PROXY_VALUE = ? where PROXY_KEY = ?");
            preparedStatement.setString(1, entity.getValue());
            preparedStatement.setString(2, entity.getProxyKey().getKeyName());
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new ProxyDaoException(e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }
}

