/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http.proxy;

import eu.europa.esig.dss.client.http.commons.DSSNotifier;
import eu.europa.esig.dss.client.http.proxy.ProxyDao;
import eu.europa.esig.dss.client.http.proxy.ProxyKey;
import eu.europa.esig.dss.client.http.proxy.ProxyPreference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyPreferenceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyPreferenceManager.class);
    private ProxyDao proxyDao;
    Set<DSSNotifier> notifiers = new HashSet<DSSNotifier>();

    public String getHttpExcludedHosts() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_EXCLUDE);
        return preference != null ? preference.getValue() : "";
    }

    public String getHttpsExcludedHosts() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_EXCLUDE);
        return preference != null ? preference.getValue() : "";
    }

    public ProxyPreference get(ProxyKey proxyKey) {
        return this.getProxyDao().get(proxyKey);
    }

    public String getHttpHost() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_HOST);
        return preference != null ? preference.getValue() : "";
    }

    public String getHttpPassword() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_PASSWORD);
        return preference != null ? preference.getValue() : "";
    }

    public Long getHttpPort() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_PORT);
        return preference != null ? Long.valueOf(preference.getValue()) : null;
    }

    public String getHttpsHost() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_HOST);
        return preference != null ? preference.getValue() : "";
    }

    public String getHttpsPassword() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_PASSWORD);
        return preference != null ? preference.getValue() : "";
    }

    public Long getHttpsPort() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_PORT);
        return preference != null ? Long.valueOf(preference.getValue()) : null;
    }

    public String getHttpsUser() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_USER);
        return preference != null ? preference.getValue() : "";
    }

    public String getHttpUser() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_USER);
        return preference != null ? preference.getValue() : "";
    }

    public boolean isHttpEnabled() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_ENABLED);
        if (preference == null || StringUtils.isEmpty((String)preference.getValue())) {
            return false;
        }
        return Boolean.valueOf(preference.getValue());
    }

    public boolean isHttpsEnabled() {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_ENABLED);
        if (preference == null || StringUtils.isEmpty((String)preference.getValue())) {
            return false;
        }
        return Boolean.valueOf(preference.getValue());
    }

    public Collection<ProxyPreference> list() {
        return this.getProxyDao().getAll();
    }

    public void setHttpEnabled(boolean enabled) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_ENABLED);
        preference.setValue(String.valueOf(enabled));
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpHost(String host) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_HOST);
        preference.setValue(host);
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpPassword(String password) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_PASSWORD);
        preference.setValue(password);
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpPort(Long port) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_PORT);
        preference.setValue(port != null ? String.valueOf(port) : "");
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpsEnabled(boolean enabled) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_ENABLED);
        preference.setValue(String.valueOf(enabled));
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpsHost(String host) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_HOST);
        preference.setValue(host);
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpsPassword(String password) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_PASSWORD);
        preference.setValue(password);
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpsPort(Long port) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_PORT);
        preference.setValue(port != null ? String.valueOf(port) : "");
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpsUser(String user) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_USER);
        preference.setValue(user);
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpUser(String httpUser) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_USER);
        preference.setValue(httpUser);
        this.getProxyDao().update(preference);
        this.dssNotify();
    }

    public void setHttpExcludedHosts(String list) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTP_EXCLUDE);
        preference.setValue(list);
        this.getProxyDao().update(preference);
    }

    public void setHttpsExcludedHosts(String list) {
        ProxyPreference preference = this.getProxyDao().get(ProxyKey.HTTPS_EXCLUDE);
        preference.setValue(list);
        this.getProxyDao().update(preference);
    }

    public void setProxyDao(ProxyDao proxyDao) {
        this.proxyDao = proxyDao;
        this.dssNotify();
    }

    private ProxyDao getProxyDao() {
        if (this.proxyDao == null) {
            throw new IllegalStateException("The proxyDao property must be set to use this class!");
        }
        return this.proxyDao;
    }

    public void update(ProxyKey proxyKey, String value) {
        switch (proxyKey) {
            case HTTP_ENABLED: {
                this.setHttpEnabled(Boolean.valueOf(value));
                break;
            }
            case HTTP_HOST: {
                this.setHttpHost(value);
                break;
            }
            case HTTP_PASSWORD: {
                this.setHttpPassword(value);
                break;
            }
            case HTTP_PORT: {
                this.setHttpPort(Long.valueOf(value));
                break;
            }
            case HTTP_USER: {
                this.setHttpUser(value);
                break;
            }
            case HTTP_EXCLUDE: {
                this.setHttpExcludedHosts(value);
                break;
            }
            case HTTPS_ENABLED: {
                this.setHttpsEnabled(Boolean.valueOf(value));
                break;
            }
            case HTTPS_HOST: {
                this.setHttpsHost(value);
                break;
            }
            case HTTPS_PASSWORD: {
                this.setHttpsPassword(value);
                break;
            }
            case HTTPS_PORT: {
                this.setHttpsPort(Long.valueOf(value));
                break;
            }
            case HTTPS_USER: {
                this.setHttpsUser(value);
                break;
            }
            case HTTPS_EXCLUDE: {
                this.setHttpsExcludedHosts(value);
            }
        }
    }

    private void dssNotify() {
        for (DSSNotifier dssNotifier : this.notifiers) {
            LOG.trace(">>> NOTIFY: " + dssNotifier);
            dssNotifier.update();
        }
    }

    public void update(String key, String value) {
        this.update(ProxyKey.fromKey(key), value);
    }

    public void addNotifier(DSSNotifier dssNotifier) {
        if (!this.notifiers.contains(dssNotifier)) {
            LOG.trace(">>> NOTIFIER ADDED: " + dssNotifier);
            this.notifiers.add(dssNotifier);
        }
    }

    public String toString() {
        return "ProxyPreferenceManager{proxyDao=" + this.proxyDao + '}';
    }
}

