/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.ocsp;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.client.NonceSource;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.client.http.commons.OCSPDataLoader;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.ocsp.OCSPRespStatus;
import eu.europa.esig.dss.x509.ocsp.OCSPSource;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineOCSPSource
implements OCSPSource {
    private static final Logger logger = LoggerFactory.getLogger(OnlineOCSPSource.class);
    private NonceSource nonceSource;
    private DataLoader dataLoader = new OCSPDataLoader();

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public void setNonceSource(NonceSource nonceSource) {
        this.nonceSource = nonceSource;
    }

    public OCSPToken getOCSPToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        if (this.dataLoader == null) {
            throw new NullPointerException("DataLoad is not provided !");
        }
        try {
            String dssIdAsString = certificateToken.getDSSIdAsString();
            logger.trace("--> OnlineOCSPSource queried for " + dssIdAsString);
            String ocspAccessLocation = this.getAccessLocation(certificateToken);
            if (StringUtils.isEmpty((String)ocspAccessLocation)) {
                logger.debug("No OCSP location found for " + dssIdAsString);
                certificateToken.extraInfo().infoNoOcspUriFoundInCertificate();
                return null;
            }
            OCSPToken ocspToken = new OCSPToken();
            ocspToken.setSourceURL(ocspAccessLocation);
            CertificateID certId = DSSRevocationUtils.getOCSPCertificateID((CertificateToken)certificateToken, (CertificateToken)issuerCertificateToken);
            byte[] content = this.buildOCSPRequest(certId);
            byte[] ocspRespBytes = this.dataLoader.post(ocspAccessLocation, content);
            if (ArrayUtils.isEmpty((byte[])ocspRespBytes)) {
                return ocspToken;
            }
            ocspToken.setAvailable(true);
            OCSPResp ocspResp = new OCSPResp(ocspRespBytes);
            OCSPRespStatus status = OCSPRespStatus.fromInt((int)ocspResp.getStatus());
            ocspToken.setResponseStatus(status);
            if (OCSPRespStatus.SUCCESSFUL.equals((Object)status)) {
                BasicOCSPResp basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
                ocspToken.setBasicOCSPResp(basicOCSPResp);
                if (this.nonceSource != null) {
                    ocspToken.setUseNonce(true);
                    ocspToken.setNonceMatch(this.isNonceMatch(basicOCSPResp));
                }
                ocspToken.setBestSingleResp(this.getBestSingleResp(basicOCSPResp, certId));
            }
            return ocspToken;
        }
        catch (OCSPException e) {
            throw new DSSException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    private byte[] buildOCSPRequest(CertificateID certId) throws DSSException {
        try {
            OCSPReqBuilder ocspReqBuilder = new OCSPReqBuilder();
            ocspReqBuilder.addRequest(certId);
            if (this.nonceSource != null) {
                Extension extension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(this.nonceSource.getNonce().toByteArray()));
                Extensions extensions = new Extensions(extension);
                ocspReqBuilder.setRequestExtensions(extensions);
            }
            OCSPReq ocspReq = ocspReqBuilder.build();
            byte[] ocspReqData = ocspReq.getEncoded();
            return ocspReqData;
        }
        catch (OCSPException e) {
            throw new DSSException("Cannot build OCSP Request", (Throwable)e);
        }
        catch (IOException e) {
            throw new DSSException("Cannot build OCSP Request", (Throwable)e);
        }
    }

    private boolean isNonceMatch(BasicOCSPResp basicOCSPResp) {
        Extension extension = basicOCSPResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        DEROctetString derReceivedNonce = (DEROctetString)extension.getExtnValue();
        BigInteger receivedNonce = new BigInteger(derReceivedNonce.getOctets());
        return receivedNonce.equals(this.nonceSource.getNonce());
    }

    private SingleResp getBestSingleResp(BasicOCSPResp basicOCSPResp, CertificateID certId) {
        Date bestUpdate = null;
        SingleResp bestSingleResp = null;
        for (SingleResp singleResp : basicOCSPResp.getResponses()) {
            if (!DSSRevocationUtils.matches((CertificateID)certId, (SingleResp)singleResp)) continue;
            Date thisUpdate = singleResp.getThisUpdate();
            if (bestUpdate != null && !thisUpdate.after(bestUpdate)) continue;
            bestSingleResp = singleResp;
            bestUpdate = thisUpdate;
        }
        return bestSingleResp;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAccessLocation(CertificateToken certificate) throws DSSException {
        block10: {
            authInfoAccessExtensionValue = certificate.getCertificate().getExtensionValue(Extension.authorityInfoAccess.getId());
            if (ArrayUtils.isEmpty((byte[])authInfoAccessExtensionValue)) {
                return null;
            }
            ais1 = null;
            ais2 = null;
            try {
                ais1 = new ASN1InputStream(authInfoAccessExtensionValue);
                oct = (DEROctetString)ais1.readObject();
                ais2 = new ASN1InputStream(oct.getOctets());
                authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)ais2.readObject());
                var8_9 = accessDescriptions = authorityInformationAccess.getAccessDescriptions();
                var9_10 = var8_9.length;
                var10_11 = 0;
lbl14:
                // 2 sources

                while (var10_11 < var9_10) {
                    block11: {
                        accessDescription = var8_9[var10_11];
                        if (OnlineOCSPSource.logger.isDebugEnabled()) {
                            OnlineOCSPSource.logger.debug("Access method OID : " + accessDescription.getAccessMethod());
                        }
                        if (!(correctAccessMethod = X509ObjectIdentifiers.ocspAccessMethod.equals((Object)accessDescription.getAccessMethod()))) ** GOTO lbl-1000
                        gn = accessDescription.getAccessLocation();
                        if (gn.getTagNo() == 6) break block11;
                        if (OnlineOCSPSource.logger.isDebugEnabled()) {
                            OnlineOCSPSource.logger.debug("Not a uniform resource identifier");
                        }
                        ** GOTO lbl-1000
                    }
                    str = (DERIA5String)((DERTaggedObject)gn.toASN1Primitive()).getObject();
                    accessLocation = str.getString();
                    if (OnlineOCSPSource.logger.isDebugEnabled()) {
                        OnlineOCSPSource.logger.debug("Access location: " + accessLocation);
                    }
                    var16_17 = accessLocation;
                    break block10;
                }
                ** GOTO lbl45
            }
            catch (IOException e) {
                try {
                    throw new DSSException((Throwable)e);
                }
                catch (Throwable var17_18) {
                    IOUtils.closeQuietly(ais1);
                    IOUtils.closeQuietly(ais2);
                    throw var17_18;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)ais1);
        IOUtils.closeQuietly((InputStream)ais2);
        return var16_17;
lbl-1000:
        // 2 sources

        {
            ++var10_11;
            ** GOTO lbl14
lbl45:
            // 1 sources

            var8_9 = null;
        }
        IOUtils.closeQuietly((InputStream)ais1);
        IOUtils.closeQuietly((InputStream)ais2);
        return var8_9;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

