/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.tsp;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.client.NonceSource;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.client.http.NativeHTTPDataLoader;
import eu.europa.esig.dss.x509.tsp.TSPSource;
import java.io.IOException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineTSPSource
implements TSPSource {
    private static final Logger logger = LoggerFactory.getLogger(OnlineTSPSource.class);
    private String tspServer;
    private ASN1ObjectIdentifier policyOid;
    private DataLoader dataLoader;
    private NonceSource nonceSource;

    public OnlineTSPSource() {
        this(null);
    }

    public OnlineTSPSource(String tspServer) {
        this.tspServer = tspServer;
    }

    public void setTspServer(String tspServer) {
        this.tspServer = tspServer;
    }

    public void setPolicyOid(String policyOid) {
        this.policyOid = new ASN1ObjectIdentifier(policyOid);
    }

    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    public void setNonceSource(NonceSource nonceSource) {
        this.nonceSource = nonceSource;
    }

    public TimeStampToken getTimeStampResponse(DigestAlgorithm digestAlgorithm, byte[] digest) throws DSSException {
        try {
            TimeStampToken timeStampToken;
            if (logger.isTraceEnabled()) {
                logger.trace("Timestamp digest algorithm: " + digestAlgorithm.getName());
                logger.trace("Timestamp digest value    : " + Hex.encodeHexString((byte[])digest));
            }
            TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
            tsqGenerator.setCertReq(true);
            if (this.policyOid != null) {
                tsqGenerator.setReqPolicy(this.policyOid);
            }
            ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier(digestAlgorithm.getOid());
            TimeStampRequest timeStampRequest = null;
            timeStampRequest = this.nonceSource == null ? tsqGenerator.generate(asn1ObjectIdentifier, digest) : tsqGenerator.generate(asn1ObjectIdentifier, digest, this.nonceSource.getNonce());
            byte[] requestBytes = timeStampRequest.getEncoded();
            if (this.dataLoader == null) {
                this.dataLoader = new NativeHTTPDataLoader();
            }
            byte[] respBytes = this.dataLoader.post(this.tspServer, requestBytes);
            TimeStampResponse timeStampResponse = new TimeStampResponse(respBytes);
            timeStampResponse.validate(timeStampRequest);
            String statusString = timeStampResponse.getStatusString();
            if (statusString != null) {
                logger.info("Status: " + statusString);
            }
            if ((timeStampToken = timeStampResponse.getTimeStampToken()) != null) {
                logger.info("TSP SID : SN " + timeStampToken.getSID().getSerialNumber() + ", Issuer " + timeStampToken.getSID().getIssuer());
            }
            return timeStampToken;
        }
        catch (TSPException e) {
            throw new DSSException("Invalid TSP response", (Throwable)e);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }
}

