/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import java.util.ResourceBundle;

public class DSSEncodingException
extends RuntimeException {
    private ResourceBundle bundle = ResourceBundle.getBundle("eu/europa/esig/dss/i18n");
    private MSG key;

    public DSSEncodingException(MSG key) {
        this.init(key);
    }

    public DSSEncodingException(MSG key, Throwable cause) {
        super(cause);
        this.init(key);
    }

    private void init(MSG key) {
        if (key == null) {
            throw new IllegalArgumentException("Cannot build Exception without a message");
        }
        this.key = key;
    }

    @Override
    public String getLocalizedMessage() {
        return this.bundle.getString(this.key.toString());
    }

    public static enum MSG {
        CERTIFICATE_CANNOT_BE_READ,
        OCSP_CANNOT_BE_READ,
        SIGNATURE_METHOD_ERROR,
        SIGNING_CERTIFICATE_ENCODING,
        SIGNING_TIME_ENCODING,
        SIGNATURE_POLICY_ENCODING,
        COUNTERSIGNATURE_ENCODING,
        SIGNATURE_TIMESTAMP_ENCODING,
        TIMESTAMP_X1_ENCODING,
        TIMESTAMP_X2_ENCODING,
        ARCHIVE_TIMESTAMP_ENCODING,
        CERTIFICATE_REF_ENCODING,
        CRL_REF_ENCODING,
        OCSP_REF_ENCODING,
        SIGNATURE_TIMESTAMP_DATA_ENCODING,
        TIMESTAMP_X1_DATA_ENCODING,
        TIMESTAMP_X2_DATA_ENCODING,
        ARCHIVE_TIMESTAMP_DATA_ENCODING,
        CRL_CANNOT_BE_WRITTEN;

    }
}

