/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.crl.CRLReasonEnum;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.ocsp.ResponseBytes;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSSRevocationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSRevocationUtils.class);
    private static JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();

    private DSSRevocationUtils() {
    }

    public static final BasicOCSPResp fromRespToBasic(OCSPResp ocspResp) {
        try {
            return (BasicOCSPResp)ocspResp.getResponseObject();
        }
        catch (OCSPException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static final OCSPResp fromBasicToResp(BasicOCSPResp basicOCSPResp) {
        try {
            byte[] encoded = basicOCSPResp.getEncoded();
            OCSPResp ocspResp = DSSRevocationUtils.fromBasicToResp(encoded);
            return ocspResp;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static final OCSPResp fromBasicToResp(byte[] basicOCSPResp) {
        OCSPResponseStatus responseStatus = new OCSPResponseStatus(0);
        DEROctetString derBasicOCSPResp = new DEROctetString(basicOCSPResp);
        ResponseBytes responseBytes = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1OctetString)derBasicOCSPResp);
        OCSPResponse ocspResponse = new OCSPResponse(responseStatus, responseBytes);
        OCSPResp ocspResp = new OCSPResp(ocspResponse);
        return ocspResp;
    }

    public static String getRevocationReason(X509CRLEntry crlEntry) {
        String reasonId = Extension.reasonCode.getId();
        byte[] extensionBytes = crlEntry.getExtensionValue(reasonId);
        if (Utils.isArrayEmpty((byte[])extensionBytes)) {
            LOG.warn("Empty reasonCode extension for crl entry");
            return null;
        }
        String reason = null;
        try {
            ASN1Enumerated reasonCodeExtension = ASN1Enumerated.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])extensionBytes));
            CRLReason crlReason = CRLReason.getInstance((Object)reasonCodeExtension);
            int intValue = crlReason.getValue().intValue();
            reason = CRLReasonEnum.fromInt((int)intValue).name();
        }
        catch (IOException e) {
            LOG.error("Unable to retrieve the crl reason : " + e.getMessage(), (Throwable)e);
        }
        return reason;
    }

    public static boolean matches(CertificateID certId, SingleResp singleResp) {
        CertificateID singleRespCertID = singleResp.getCertID();
        ASN1ObjectIdentifier singleRespCertIDHashAlgOID = singleRespCertID.getHashAlgOID();
        byte[] singleRespCertIDIssuerKeyHash = singleRespCertID.getIssuerKeyHash();
        byte[] singleRespCertIDIssuerNameHash = singleRespCertID.getIssuerNameHash();
        BigInteger singleRespCertIDSerialNumber = singleRespCertID.getSerialNumber();
        ASN1ObjectIdentifier certIdHashAlgOID = certId.getHashAlgOID();
        byte[] certIdIssuerKeyHash = certId.getIssuerKeyHash();
        byte[] certIdIssuerNameHash = certId.getIssuerNameHash();
        BigInteger certIdSerialNumber = certId.getSerialNumber();
        return singleRespCertIDHashAlgOID.equals((Object)certIdHashAlgOID) && Arrays.equals(singleRespCertIDIssuerKeyHash, certIdIssuerKeyHash) && Arrays.equals(singleRespCertIDIssuerNameHash, certIdIssuerNameHash) && singleRespCertIDSerialNumber.equals(certIdSerialNumber);
    }

    public static CertificateID getOCSPCertificateID(CertificateToken cert, CertificateToken issuerCert) throws DSSException {
        try {
            BigInteger serialNumber = cert.getSerialNumber();
            DigestCalculator digestCalculator = DSSRevocationUtils.getSHA1DigestCalculator();
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(issuerCert);
            CertificateID certificateID = new CertificateID(digestCalculator, x509CertificateHolder, serialNumber);
            return certificateID;
        }
        catch (OCSPException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static DigestCalculator getSHA1DigestCalculator() throws DSSException {
        try {
            DigestCalculatorProvider digestCalculatorProvider = jcaDigestCalculatorProviderBuilder.build();
            DigestCalculator digestCalculator = digestCalculatorProvider.get(CertificateID.HASH_SHA1);
            return digestCalculator;
        }
        catch (OperatorCreationException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static BasicOCSPResp loadOCSPBase64Encoded(String base64Encoded) throws IOException, OCSPException {
        byte[] derEncoded = Utils.fromBase64((String)base64Encoded);
        OCSPResp ocspResp = new OCSPResp(derEncoded);
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
        return basicOCSPResp;
    }

    public static byte[] getEncoded(OCSPResp ocspResp) {
        try {
            byte[] encoded = ocspResp.getEncoded();
            return encoded;
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static byte[] getEncoded(X509CRL x509CRL) {
        try {
            byte[] encoded = x509CRL.getEncoded();
            return encoded;
        }
        catch (CRLException e) {
            throw new DSSException((Throwable)e);
        }
    }

    static {
        jcaDigestCalculatorProviderBuilder.setProvider("BC");
    }
}

