/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.client.http;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.client.http.NativeDataLoaderCall;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeHTTPDataLoader
implements DataLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeHTTPDataLoader.class);
    private long maxInputSize;
    private long timeout = 0L;

    protected byte[] request(String url, HttpMethod method, byte[] content, boolean refresh) {
        NativeDataLoaderCall task = new NativeDataLoaderCall(url, content, refresh, this.maxInputSize);
        Future<byte[]> result = Executors.newSingleThreadExecutor().submit(task);
        try {
            return this.timeout > 0L ? result.get(this.timeout, TimeUnit.MILLISECONDS) : result.get();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new DSSException((Throwable)e);
        }
    }

    @Override
    public DataLoader.DataAndUrl get(List<String> urlStrings) {
        for (String urlString : urlStrings) {
            try {
                byte[] bytes = this.get(urlString);
                if (bytes == null) continue;
                return new DataLoader.DataAndUrl(bytes, urlString);
            }
            catch (Exception e) {
                LOGGER.warn("Impossible to obtain data using {}", (Object)urlString, (Object)e);
            }
        }
        throw new DSSException(String.format("Impossible to obtain data using with given urls %s", urlStrings));
    }

    @Override
    public byte[] get(String url) {
        return this.get(url, false);
    }

    @Override
    public byte[] get(String url, boolean refresh) {
        return this.request(url, HttpMethod.GET, null, !refresh);
    }

    @Override
    public byte[] post(String url, byte[] content) {
        return this.request(url, HttpMethod.POST, content, false);
    }

    @Override
    public void setContentType(String contentType) {
        throw new DSSException("Not implemented");
    }

    public long getMaxInputSize() {
        return this.maxInputSize;
    }

    public void setMaxInputSize(long maxInputSize) {
        this.maxInputSize = maxInputSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public static enum HttpMethod {
        GET,
        POST;

    }
}

