/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.ArrayList;
import java.util.List;

public class CompositeCondition
extends Condition {
    protected List<Condition> children;

    public void addChild(Condition condition) {
        if (this.children == null) {
            this.children = new ArrayList<Condition>();
        }
        this.children.add(condition);
    }

    public boolean check(CertificateToken certificateToken) {
        if (this.children == null) {
            return false;
        }
        for (Condition condition : this.children) {
            boolean checkResult = condition.check(certificateToken);
            if (checkResult) continue;
            return false;
        }
        return true;
    }

    public String toString(String indent) {
        try {
            if (indent == null) {
                indent = "";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(indent).append("CompositeCondition: ").append('\n');
            if (this.children != null) {
                indent = indent + "\t";
                for (Condition condition : this.children) {
                    builder.append(condition.toString(indent));
                }
            }
            return builder.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public String toString() {
        return this.toString("");
    }
}

