/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.tsl.ServiceInfo;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatePool
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CertificatePool.class);
    private Map<String, CertificateToken> certById = new HashMap<String, CertificateToken>();
    private Map<String, List<CertificateToken>> certBySubject = new HashMap<String, List<CertificateToken>>();

    public CertificateToken getInstance(CertificateToken cert, CertificateSourceType certSource) {
        return this.getInstance(cert, certSource, (ServiceInfo)null);
    }

    public CertificateToken getInstance(CertificateToken cert, CertificateSourceType certSource, ServiceInfo serviceInfo) {
        HashSet<ServiceInfo> services = new HashSet<ServiceInfo>();
        if (serviceInfo != null) {
            services.add(serviceInfo);
        }
        HashSet<CertificateSourceType> sources = new HashSet<CertificateSourceType>();
        if (certSource != null) {
            sources.add(certSource);
        }
        return this.getInstance(cert, sources, services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateToken getInstance(CertificateToken certificateToAdd, Set<CertificateSourceType> sources, Set<ServiceInfo> services) {
        if (certificateToAdd == null) {
            throw new NullPointerException("The certificate must be filled");
        }
        if (Utils.isCollectionEmpty(sources)) {
            throw new IllegalStateException("The certificate source type must be set.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Certificate to add: " + certificateToAdd.getIssuerX500Principal() + "|" + certificateToAdd.getSerialNumber());
        }
        String id = certificateToAdd.getDSSIdAsString();
        Map<String, CertificateToken> map = this.certById;
        synchronized (map) {
            CertificateToken certToken = this.certById.get(id);
            if (certToken == null) {
                LOG.trace("Certificate " + id + " is not in the pool");
                certToken = certificateToAdd;
                this.certById.put(id, certToken);
                String subjectName = certificateToAdd.getSubjectX500Principal().getName("CANONICAL");
                List<CertificateToken> list = this.certBySubject.get(subjectName);
                if (list == null) {
                    list = new ArrayList<CertificateToken>();
                    this.certBySubject.put(subjectName, list);
                }
                list.add(certToken);
            } else {
                LOG.trace("Certificate " + id + " is already in the pool");
                X509Certificate foundCertificate = certToken.getCertificate();
                byte[] foundCertificateSignature = foundCertificate.getSignature();
                byte[] certificateToAddSignature = certificateToAdd.getSignature();
                if (!Arrays.equals(foundCertificateSignature, certificateToAddSignature)) {
                    LOG.warn(" Found certificate: " + certToken.getIssuerX500Principal().toString() + "|" + certToken.getSerialNumber());
                    LOG.warn("More than one certificate for the same issuer subject name and serial number! The standard is not met by the certificate issuer!");
                }
            }
            for (CertificateSourceType sourceType : sources) {
                certToken.addSourceType(sourceType);
            }
            if (services != null) {
                for (ServiceInfo serviceInfo : services) {
                    certToken.addServiceInfo(serviceInfo);
                }
            }
            return certToken;
        }
    }

    public List<CertificateToken> getCertificateTokens() {
        ArrayList<CertificateToken> certificateTokenArrayList = new ArrayList<CertificateToken>(this.certById.values());
        return Collections.unmodifiableList(certificateTokenArrayList);
    }

    public int getNumberOfCertificates() {
        return this.certById.size();
    }

    public void merge(CertificatePool certPool) {
        List<CertificateToken> certTokens = certPool.getCertificateTokens();
        for (CertificateToken certificateToken : certTokens) {
            this.getInstance(certificateToken, certificateToken.getSources(), certificateToken.getAssociatedTSPS());
        }
    }

    public List<CertificateToken> get(X500Principal x500Principal) {
        List<Object> certificateTokenList = null;
        if (x500Principal != null) {
            String x500PrincipalCanonicalized = x500Principal.getName("CANONICAL");
            certificateTokenList = this.certBySubject.get(x500PrincipalCanonicalized);
        }
        if (certificateTokenList == null) {
            certificateTokenList = new ArrayList();
        }
        return Collections.unmodifiableList(certificateTokenList);
    }
}

