/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.tsl.ServiceInfo;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class CommonCertificateSource
implements CertificateSource {
    protected CertificatePool certPool;
    protected List<CertificateToken> certificateTokens;

    public CommonCertificateSource() {
        this.certPool = new CertificatePool();
    }

    public CommonCertificateSource(CertificatePool certPool) {
        if (certPool == null) {
            throw new NullPointerException();
        }
        this.certPool = certPool;
    }

    protected CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.OTHER;
    }

    @Override
    public CertificatePool getCertificatePool() {
        return this.certPool;
    }

    @Override
    public CertificateToken addCertificate(CertificateToken x509Certificate) {
        CertificateToken certToken = this.certPool.getInstance(x509Certificate, this.getCertificateSourceType());
        if (this.certificateTokens != null && !this.certificateTokens.contains(certToken)) {
            this.certificateTokens.add(certToken);
        }
        return certToken;
    }

    public List<CertificateToken> getCertificates() {
        return Collections.unmodifiableList(this.certificateTokens);
    }

    @Override
    public List<CertificateToken> get(X500Principal x500Principal) {
        List<Object> certificateTokenList = null;
        if (x500Principal != null) {
            ArrayList<CertificateToken> missingCertificateTokens = new ArrayList<CertificateToken>();
            certificateTokenList = this.certPool.get(x500Principal);
            for (CertificateToken certificateToken : certificateTokenList) {
                if (this.certificateTokens.contains(certificateToken)) continue;
                missingCertificateTokens.add(certificateToken);
            }
            if (missingCertificateTokens.size() > 0) {
                certificateTokenList.removeAll(missingCertificateTokens);
            }
        } else {
            certificateTokenList = new ArrayList();
        }
        return Collections.unmodifiableList(certificateTokenList);
    }

    protected CertificateToken addCertificate(CertificateToken certificate, ServiceInfo serviceInfo) {
        CertificateToken certToken = this.certPool.getInstance(certificate, this.getCertificateSourceType(), serviceInfo);
        if (this.certificateTokens != null && !this.certificateTokens.contains(certToken)) {
            this.certificateTokens.add(certToken);
        }
        return certToken;
    }

    public boolean removeCertificate(CertificateToken certificate) {
        if (this.certificateTokens != null && this.certificateTokens.contains(certificate)) {
            return this.certificateTokens.remove(certificate);
        }
        return false;
    }

    public boolean removeX500Principal(X500Principal x500Principal) {
        boolean removed = false;
        if (this.certificateTokens != null) {
            List<CertificateToken> listToRemove = this.get(x500Principal);
            for (CertificateToken certificateToken : listToRemove) {
                removed |= this.removeCertificate(certificateToken);
            }
        }
        return removed;
    }
}

