/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.crl;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSNotApplicableMethodException;
import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.TokenValidationExtraInfo;
import eu.europa.esig.dss.x509.crl.CRLValidity;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLToken
extends RevocationToken {
    private static final Logger LOG = LoggerFactory.getLogger(CRLToken.class);
    private final CRLValidity crlValidity;

    public CRLToken(CertificateToken certificateToken, CRLValidity crlValidity) {
        if (crlValidity == null) {
            throw new NullPointerException();
        }
        this.crlValidity = crlValidity;
        this.copyCommonValuesFromCRL();
        this.setRevocationStatus(certificateToken);
        LOG.debug("+CRLToken");
    }

    private void copyCommonValuesFromCRL() {
        this.signatureAlgorithm = this.crlValidity.getSignatureAlgorithm();
        this.thisUpdate = this.crlValidity.getThisUpdate();
        this.productionDate = this.crlValidity.getThisUpdate();
        this.nextUpdate = this.crlValidity.getNextUpdate();
        this.expiredCertsOnCRL = this.crlValidity.getExpiredCertsOnCRL();
        if (this.crlValidity.getIssuerToken() != null) {
            this.issuerToken = this.crlValidity.getIssuerToken();
            this.issuerX500Principal = this.crlValidity.getIssuerToken().getSubjectX500Principal();
        }
        this.extraInfo = new TokenValidationExtraInfo();
        this.signatureValid = this.crlValidity.isSignatureIntact();
        this.signatureInvalidityReason = this.crlValidity.getSignatureInvalidityReason();
    }

    private void setRevocationStatus(CertificateToken certificateToken) {
        CertificateToken issuerToken = certificateToken.getIssuerToken();
        if (!issuerToken.equals((Object)this.crlValidity.getIssuerToken())) {
            if (!this.crlValidity.isSignatureIntact()) {
                throw new DSSException(this.crlValidity.getSignatureInvalidityReason());
            }
            throw new DSSException("The CRLToken is not signed by the same issuer as the CertificateToken to be verified!");
        }
        BigInteger serialNumber = certificateToken.getSerialNumber();
        X509CRL x509crl = this.crlValidity.getX509CRL();
        X509CRLEntry crlEntry = x509crl.getRevokedCertificate(serialNumber);
        this.status = null == crlEntry;
        if (!this.status.booleanValue()) {
            this.revocationDate = crlEntry.getRevocationDate();
            this.reason = DSSRevocationUtils.getRevocationReason(crlEntry);
        }
    }

    public X509CRL getX509crl() {
        return this.crlValidity.getX509CRL();
    }

    public boolean isSignedBy(CertificateToken issuerToken) {
        throw new DSSNotApplicableMethodException(((Object)((Object)this)).getClass());
    }

    public CRLValidity getCrlValidity() {
        return this.crlValidity;
    }

    public String getAbbreviation() {
        return "CRLToken[" + (this.productionDate == null ? "?" : DSSUtils.formatInternal(this.productionDate)) + ", signedBy=" + (this.issuerToken == null ? "?" : this.issuerToken.getDSSIdAsString()) + "]";
    }

    public byte[] getEncoded() {
        return this.crlValidity.getCrlEncoded();
    }

    public boolean isValid() {
        return this.crlValidity.isValid();
    }

    public String toString(String indentStr) {
        try {
            List validationExtraInfo;
            StringBuilder out = new StringBuilder();
            out.append(indentStr).append("CRLToken[\n");
            indentStr = indentStr + "\t";
            out.append(indentStr).append("Production time: ").append(this.productionDate == null ? "?" : DSSUtils.formatInternal(this.productionDate)).append('\n');
            out.append(indentStr).append("Signature algorithm: ").append((Object)(this.signatureAlgorithm == null ? "?" : this.signatureAlgorithm)).append('\n');
            out.append(indentStr).append("Status: ").append(this.getStatus()).append('\n');
            if (this.issuerToken != null) {
                out.append(indentStr).append("Issuer's certificate: ").append(this.issuerToken.getDSSIdAsString()).append('\n');
            }
            if ((validationExtraInfo = this.extraInfo.getValidationInfo()).size() > 0) {
                for (String info : validationExtraInfo) {
                    out.append('\n').append(indentStr).append("\t- ").append(info);
                }
                out.append('\n');
            }
            indentStr = indentStr.substring(1);
            out.append(indentStr).append(']');
            return out.toString();
        }
        catch (Exception e) {
            return ((Object)((Object)this)).toString();
        }
    }
}

