/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.crl;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.OID;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.tsl.KeyUsageBit;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.crl.CRLValidity;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.ReasonFlags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CRLUtils.class);

    public static CRLValidity isValidCRL(X509CRL x509CRL, CertificateToken issuerToken) {
        CRLValidity crlValidity = new CRLValidity();
        crlValidity.setX509CRL(x509CRL);
        try {
            crlValidity.setCrlEncoded(x509CRL.getEncoded());
        }
        catch (CRLException e) {
            LOG.error("Unable to read the CRL binaries", (Throwable)e);
        }
        String sigAlgOID = x509CRL.getSigAlgOID();
        crlValidity.setSignatureAlgorithm(SignatureAlgorithm.forOID((String)sigAlgOID));
        X500Principal x509CRLIssuerX500Principal = DSSUtils.getNormalizedX500Principal(x509CRL.getIssuerX500Principal());
        X500Principal issuerTokenSubjectX500Principal = DSSUtils.getNormalizedX500Principal(issuerToken.getSubjectX500Principal());
        if (x509CRLIssuerX500Principal.equals(issuerTokenSubjectX500Principal)) {
            crlValidity.setIssuerX509PrincipalMatches(true);
        }
        crlValidity.setThisUpdate(x509CRL.getThisUpdate());
        crlValidity.setNextUpdate(x509CRL.getNextUpdate());
        crlValidity.setExpiredCertsOnCRL(CRLUtils.getExpiredCertsOnCRL(x509CRL));
        CRLUtils.checkCriticalExtensions(x509CRL, crlValidity);
        CRLUtils.checkSignatureValue(x509CRL, issuerToken, crlValidity);
        if (crlValidity.isSignatureIntact()) {
            crlValidity.setCrlSignKeyUsage(CRLUtils.hasCRLSignKeyUsage(issuerToken));
        }
        return crlValidity;
    }

    static boolean hasCRLSignKeyUsage(CertificateToken token) {
        return token.checkKeyUsage(KeyUsageBit.crlSign);
    }

    private static void checkSignatureValue(X509CRL x509CRL, CertificateToken issuerToken, CRLValidity crlValidity) {
        try {
            x509CRL.verify(issuerToken.getPublicKey());
            crlValidity.setSignatureIntact(true);
            crlValidity.setIssuerToken(issuerToken);
        }
        catch (InvalidKeyException e) {
            crlValidity.setSignatureInvalidityReason(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        catch (CRLException e) {
            crlValidity.setSignatureInvalidityReason(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            crlValidity.setSignatureInvalidityReason(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        catch (SignatureException e) {
            crlValidity.setSignatureInvalidityReason(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new DSSException((Throwable)e);
        }
    }

    private static void checkCriticalExtensions(X509CRL x509CRL, CRLValidity crlValidity) {
        Set<String> criticalExtensionOIDs = x509CRL.getCriticalExtensionOIDs();
        if (criticalExtensionOIDs == null || criticalExtensionOIDs.isEmpty()) {
            crlValidity.setUnknownCriticalExtension(false);
        } else {
            GeneralNames generalNames;
            byte[] extensionValue = x509CRL.getExtensionValue(Extension.issuingDistributionPoint.getId());
            IssuingDistributionPoint issuingDistributionPoint = IssuingDistributionPoint.getInstance((Object)ASN1OctetString.getInstance((Object)extensionValue).getOctets());
            boolean onlyAttributeCerts = issuingDistributionPoint.onlyContainsAttributeCerts();
            boolean onlyCaCerts = issuingDistributionPoint.onlyContainsCACerts();
            boolean onlyUserCerts = issuingDistributionPoint.onlyContainsUserCerts();
            boolean indirectCrl = issuingDistributionPoint.isIndirectCRL();
            ReasonFlags onlySomeReasons = issuingDistributionPoint.getOnlySomeReasons();
            DistributionPointName distributionPoint = issuingDistributionPoint.getDistributionPoint();
            boolean urlFound = false;
            if (0 == distributionPoint.getType() && (generalNames = (GeneralNames)distributionPoint.getName()) != null && generalNames.getNames() != null && generalNames.getNames().length > 0) {
                for (GeneralName generalName : generalNames.getNames()) {
                    if (6 != generalName.getTagNo()) continue;
                    urlFound = true;
                }
            }
            if (!(onlyAttributeCerts && onlyCaCerts && onlyUserCerts && indirectCrl || onlySomeReasons != null || !urlFound)) {
                crlValidity.setUnknownCriticalExtension(false);
            }
        }
    }

    public static Date getExpiredCertsOnCRL(X509CRL x509crl) {
        byte[] extensionValue;
        Set<String> nonCriticalExtensionOIDs = x509crl.getNonCriticalExtensionOIDs();
        if (nonCriticalExtensionOIDs != null && nonCriticalExtensionOIDs.contains(OID.id_ce_expiredCertsOnCRL.getId()) && Utils.isArrayNotEmpty((byte[])(extensionValue = x509crl.getExtensionValue(OID.id_ce_expiredCertsOnCRL.getId())))) {
            try {
                ASN1OctetString octetString = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])extensionValue);
                ASN1GeneralizedTime generalTime = (ASN1GeneralizedTime)ASN1Primitive.fromByteArray((byte[])octetString.getOctets());
                return generalTime.getDate();
            }
            catch (Exception e) {
                LOG.error("Unable to retrieve id_ce_expiredCertsOnCRL on CRL : " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

