/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.crl;

import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.x509.CertificateToken;
import java.security.cert.X509CRL;
import java.util.Date;

public class CRLValidity {
    private String key;
    private byte[] crlEncoded = null;
    private SignatureAlgorithm signatureAlgorithm;
    private Date nextUpdate;
    private Date thisUpdate;
    private Date expiredCertsOnCRL;
    private boolean issuerX509PrincipalMatches = false;
    private boolean signatureIntact = false;
    private boolean crlSignKeyUsage = false;
    private boolean unknownCriticalExtension = true;
    private CertificateToken issuerToken = null;
    private String signatureInvalidityReason = "";
    private X509CRL x509Crl;

    public X509CRL getX509CRL() {
        if (this.x509Crl == null) {
            this.x509Crl = DSSUtils.loadCRL(this.crlEncoded);
        }
        return this.x509Crl;
    }

    public void setX509CRL(X509CRL x509Crl) {
        this.x509Crl = x509Crl;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public byte[] getCrlEncoded() {
        return this.crlEncoded;
    }

    public void setCrlEncoded(byte[] crlEncoded) {
        this.crlEncoded = crlEncoded;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(Date nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public Date getExpiredCertsOnCRL() {
        return this.expiredCertsOnCRL;
    }

    public void setExpiredCertsOnCRL(Date expiredCertsOnCRL) {
        this.expiredCertsOnCRL = expiredCertsOnCRL;
    }

    public boolean isIssuerX509PrincipalMatches() {
        return this.issuerX509PrincipalMatches;
    }

    public void setIssuerX509PrincipalMatches(boolean issuerX509PrincipalMatches) {
        this.issuerX509PrincipalMatches = issuerX509PrincipalMatches;
    }

    public boolean isSignatureIntact() {
        return this.signatureIntact;
    }

    public void setSignatureIntact(boolean signatureIntact) {
        this.signatureIntact = signatureIntact;
    }

    public boolean isCrlSignKeyUsage() {
        return this.crlSignKeyUsage;
    }

    public void setCrlSignKeyUsage(boolean crlSignKeyUsage) {
        this.crlSignKeyUsage = crlSignKeyUsage;
    }

    public boolean isUnknownCriticalExtension() {
        return this.unknownCriticalExtension;
    }

    public void setUnknownCriticalExtension(boolean unknownCriticalExtension) {
        this.unknownCriticalExtension = unknownCriticalExtension;
    }

    public CertificateToken getIssuerToken() {
        return this.issuerToken;
    }

    public void setIssuerToken(CertificateToken issuerToken) {
        this.issuerToken = issuerToken;
    }

    public String getSignatureInvalidityReason() {
        return this.signatureInvalidityReason;
    }

    public void setSignatureInvalidityReason(String signatureInvalidityReason) {
        this.signatureInvalidityReason = signatureInvalidityReason;
    }

    boolean isValid() {
        return this.issuerX509PrincipalMatches && this.signatureIntact && this.crlSignKeyUsage && !this.unknownCriticalExtension;
    }

    public String toString() {
        return "CRLValidity{issuerX509PrincipalMatches=" + this.issuerX509PrincipalMatches + ", signatureIntact=" + this.signatureIntact + ", crlSignKeyUsage=" + this.crlSignKeyUsage + ", unknownCriticalExtension=" + this.unknownCriticalExtension + ", issuerToken=" + this.issuerToken + ", signatureInvalidityReason='" + this.signatureInvalidityReason + '\'' + '}';
    }
}

