/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.ocsp;

import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationOrigin;
import eu.europa.esig.dss.x509.ocsp.OCSPSource;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import java.util.Date;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfflineOCSPSource
implements OCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineOCSPSource.class);

    @Override
    public final OCSPToken getOCSPToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        List<BasicOCSPResp> containedOCSPResponses = this.getContainedOCSPResponses();
        if (LOG.isTraceEnabled()) {
            String dssIdAsString = certificateToken.getDSSIdAsString();
            LOG.trace("--> OfflineOCSPSource queried for " + dssIdAsString + " contains: " + containedOCSPResponses.size() + " element(s).");
        }
        Date bestUpdate = null;
        BasicOCSPResp bestBasicOCSPResp = null;
        CertificateID certId = DSSRevocationUtils.getOCSPCertificateID(certificateToken, issuerCertificateToken);
        for (BasicOCSPResp basicOCSPResp : containedOCSPResponses) {
            for (SingleResp singleResp : basicOCSPResp.getResponses()) {
                if (!DSSRevocationUtils.matches(certId, singleResp)) continue;
                Date thisUpdate = singleResp.getThisUpdate();
                if (bestUpdate != null && !thisUpdate.after(bestUpdate)) continue;
                bestBasicOCSPResp = basicOCSPResp;
                bestUpdate = thisUpdate;
            }
        }
        if (bestBasicOCSPResp != null) {
            OCSPToken ocspToken = new OCSPToken();
            ocspToken.setCertId(certId);
            ocspToken.setOrigin(RevocationOrigin.SIGNATURE);
            ocspToken.setBasicOCSPResp(bestBasicOCSPResp);
            return ocspToken;
        }
        return null;
    }

    public abstract List<BasicOCSPResp> getContainedOCSPResponses();
}

