/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.CommonDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.MimeType;
import java.io.File;
import java.io.InputStream;

public class FileDocument
extends CommonDocument {
    private final File file;

    public FileDocument(String path) {
        this(new File(path));
    }

    public FileDocument(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        if (!file.exists()) {
            throw new DSSException("File Not Found: " + file.getAbsolutePath());
        }
        this.file = file;
        this.name = file.getName();
        this.mimeType = MimeType.fromFileName((String)file.getName());
    }

    public InputStream openStream() throws DSSException {
        InputStream inputStream = DSSUtils.toInputStream(this.file);
        return inputStream;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public File getParentFile() {
        return this.file.getParentFile();
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }
}

