/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.FileDocument;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class ResourceLoader {
    protected Class<?> anyClass = ResourceLoader.class;

    public ResourceLoader() {
    }

    public ResourceLoader(Class<?> anyClass) {
        this.anyClass = anyClass;
    }

    public static String getNormalizedFileName(String fileName) {
        String normalizedFileName = fileName.replaceAll("\\W", "_");
        return normalizedFileName;
    }

    public String getAbsoluteSourceResourceFolder(String resourcePath) throws DSSException {
        URL uri = this.anyClass.getResource(resourcePath);
        if (uri == null) {
            return null;
        }
        String absolutePath = uri.getPath();
        try {
            String decodedAbsoluteFolder = URLDecoder.decode(absolutePath, "UTF-8");
            String finalFolder = DSSUtils.replaceStrStr(decodedAbsoluteFolder, "target/test-classes", "src/test/resources");
            finalFolder = DSSUtils.replaceStrStr(finalFolder, "target/classes", "src/main/resources");
            if (finalFolder.endsWith("/")) {
                finalFolder = finalFolder.substring(0, finalFolder.length() - 1);
            }
            return finalFolder;
        }
        catch (UnsupportedEncodingException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public String getAbsoluteSourceMainResourceFolder(String resourcePath) throws DSSException {
        URL uri = this.anyClass.getResource(resourcePath);
        if (uri == null) {
            return null;
        }
        String absolutePath = uri.getPath();
        try {
            String decodedAbsoluteFolder = URLDecoder.decode(absolutePath, "UTF-8");
            String finalFolder = DSSUtils.replaceStrStr(decodedAbsoluteFolder, "target/test-classes", "src/main/resources");
            finalFolder = DSSUtils.replaceStrStr(finalFolder, "target/classes", "src/main/resources");
            if (finalFolder.endsWith("/")) {
                finalFolder = finalFolder.substring(0, finalFolder.length() - 1);
            }
            return finalFolder;
        }
        catch (UnsupportedEncodingException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public String getAbsoluteResourceFolder(String resourcePath) throws DSSException {
        URL uri = this.anyClass.getResource(resourcePath);
        if (uri == null) {
            return null;
        }
        String absolutePath = uri.getPath();
        try {
            String decodedAbsolutePath = URLDecoder.decode(absolutePath, "UTF-8");
            return decodedAbsolutePath;
        }
        catch (UnsupportedEncodingException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public InputStream getResource(String resourcePath) {
        InputStream resourceAsStream = this.anyClass.getResourceAsStream(resourcePath);
        return resourceAsStream;
    }

    public DSSDocument getDSSDocumentFromResource(String resourcePath) {
        String absolutePath = this.getAbsoluteResourceFolder(resourcePath);
        FileDocument dssDocument = new FileDocument(absolutePath);
        return dssDocument;
    }
}

