/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.tsl.CompositeCondition;
import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.tsl.MatchingCriteriaIndicator;
import eu.europa.esig.dss.x509.CertificateToken;

public class CriteriaListCondition
extends CompositeCondition {
    private MatchingCriteriaIndicator matchingCriteriaIndicator;

    public CriteriaListCondition(MatchingCriteriaIndicator matchingCriteriaIndicator) {
        if (matchingCriteriaIndicator == null) {
            throw new NullPointerException();
        }
        this.matchingCriteriaIndicator = matchingCriteriaIndicator;
    }

    public MatchingCriteriaIndicator getMatchingCriteriaIndicator() {
        return this.matchingCriteriaIndicator;
    }

    @Override
    public boolean check(CertificateToken certificateToken) {
        switch (this.matchingCriteriaIndicator) {
            case all: {
                for (Condition condition : this.children) {
                    if (condition.check(certificateToken)) continue;
                    return false;
                }
                return true;
            }
            case atLeastOne: {
                for (Condition condition : this.children) {
                    if (!condition.check(certificateToken)) continue;
                    return true;
                }
                return false;
            }
            case none: {
                for (Condition condition : this.children) {
                    if (!condition.check(certificateToken)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new DSSException("Unsupported MatchingCriteriaIndicator : " + (Object)((Object)this.matchingCriteriaIndicator));
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(indent).append("CriteriaListCondition: ").append(this.matchingCriteriaIndicator.name()).append('\n');
            if (this.children != null) {
                indent = indent + "\t";
                for (Condition condition : this.children) {
                    builder.append(condition.toString(indent));
                }
            }
            return builder.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

