/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.x509.CertificateToken;
import java.util.List;

public class QcStatementCondition
extends Condition {
    private static final long serialVersionUID = -5504958938057542907L;
    private String qcStatementASN1Id = null;

    public QcStatementCondition(String qcStatementASN1Id) {
        this.qcStatementASN1Id = qcStatementASN1Id;
    }

    public boolean check(CertificateToken certToken) {
        List<String> extensionIdList = DSSASN1Utils.getQCStatementsIdList(certToken);
        return extensionIdList.contains(this.qcStatementASN1Id);
    }

    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        return indent + "QcStatementCondition{" + "qcStatementId='" + this.qcStatementASN1Id + '\'' + '}';
    }

    public String toString() {
        return this.toString("");
    }
}

