/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.tsl.ServiceInfo;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.CommonCertificateSource;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonTrustedCertificateSource
extends CommonCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(CommonTrustedCertificateSource.class);

    @Override
    protected CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.TRUSTED_STORE;
    }

    protected CertificateToken addCertificate(CertificateToken cert, Set<CertificateSourceType> sources, Set<ServiceInfo> services) {
        CertificateToken certToken = this.certPool.getInstance(cert, sources, services);
        return certToken;
    }

    @Override
    public CertificateToken addCertificate(CertificateToken certificate, ServiceInfo serviceInfo) {
        CertificateToken certToken = this.certPool.getInstance(certificate, this.getCertificateSourceType(), serviceInfo);
        return certToken;
    }

    public CertificateToken addX500Principal(X500Principal x500Principal, ServiceInfo serviceInfo) {
        CertificateToken certificateToken = null;
        List<CertificateToken> certificateTokens = this.get(x500Principal);
        if (certificateTokens.size() > 0) {
            certificateToken = certificateTokens.get(0);
        } else {
            LOG.debug("WARNING: There is currently no certificate with the given X500Principal: '{}' within the certificate pool!", (Object)x500Principal);
        }
        if (certificateToken != null) {
            this.addCertificate(certificateToken, serviceInfo);
        }
        return certificateToken;
    }

    public void importAsTrusted(CommonCertificateSource keyStore) {
        List<CertificateToken> certTokenList = keyStore.getCertificates();
        for (CertificateToken certToken : certTokenList) {
            this.certPool.getInstance(certToken, this.getCertificateSourceType());
        }
    }

    @Override
    public List<CertificateToken> getCertificates() {
        return this.certPool.getCertificateTokens();
    }

    @Override
    public List<CertificateToken> get(X500Principal x500Principal) {
        return this.certPool.get(x500Principal);
    }

    public int getNumberOfTrustedCertificates() {
        return this.certPool.getNumberOfCertificates();
    }
}

