/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509.crl;

import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationOrigin;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.crl.CRLUtils;
import eu.europa.esig.dss.x509.crl.CRLValidity;
import java.security.cert.X509CRL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfflineCRLSource
implements CRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineCRLSource.class);
    protected List<X509CRL> x509CRLList;
    protected Map<CertificateToken, CRLToken> validCRLTokenList = new HashMap<CertificateToken, CRLToken>();
    protected Map<X509CRL, CRLValidity> crlValidityMap = new HashMap<X509CRL, CRLValidity>();

    @Override
    public final CRLToken findCrl(CertificateToken certificateToken) {
        if (certificateToken == null) {
            throw new NullPointerException();
        }
        CRLToken validCRLToken = this.validCRLTokenList.get(certificateToken);
        if (validCRLToken != null) {
            validCRLToken.setOrigin(RevocationOrigin.SIGNATURE);
            return validCRLToken;
        }
        CertificateToken issuerToken = certificateToken.getIssuerToken();
        if (issuerToken == null) {
            throw new NullPointerException();
        }
        CRLValidity bestCRLValidity = this.getBestCrlValidity(certificateToken, issuerToken);
        if (bestCRLValidity == null) {
            return null;
        }
        CRLToken crlToken = new CRLToken(certificateToken, bestCRLValidity);
        crlToken.setOrigin(RevocationOrigin.SIGNATURE);
        this.validCRLTokenList.put(certificateToken, crlToken);
        return crlToken;
    }

    private CRLValidity getBestCrlValidity(CertificateToken certificateToken, CertificateToken issuerToken) {
        CRLValidity bestCRLValidity = null;
        Date bestX509UpdateDate = null;
        for (X509CRL x509CRL : this.x509CRLList) {
            boolean periodAreIntersecting;
            CRLValidity crlValidity = this.getCrlValidity(issuerToken, x509CRL);
            if (crlValidity == null || !issuerToken.equals((Object)crlValidity.getIssuerToken()) || !crlValidity.isValid()) continue;
            Date thisUpdate = x509CRL.getThisUpdate();
            Date nextUpdate = x509CRL.getNextUpdate();
            Date notAfter = certificateToken.getNotAfter();
            Date notBefore = certificateToken.getNotBefore();
            boolean bl = periodAreIntersecting = thisUpdate.before(notAfter) && nextUpdate != null && nextUpdate.after(notBefore);
            if (!periodAreIntersecting) {
                LOG.warn("The CRL was not issued during the validity period of the certificate! Certificate: " + certificateToken.getDSSIdAsString());
                continue;
            }
            if (bestX509UpdateDate != null && !thisUpdate.after(bestX509UpdateDate)) continue;
            bestCRLValidity = crlValidity;
            bestX509UpdateDate = thisUpdate;
        }
        return bestCRLValidity;
    }

    private synchronized CRLValidity getCrlValidity(CertificateToken issuerToken, X509CRL x509CRL) {
        CRLValidity crlValidity = this.crlValidityMap.get(x509CRL);
        if (crlValidity == null && (crlValidity = CRLUtils.isValidCRL(x509CRL, issuerToken)).isValid()) {
            this.crlValidityMap.put(x509CRL, crlValidity);
        }
        return crlValidity;
    }

    public List<X509CRL> getContainedX509CRLs() {
        List<X509CRL> x509CRLs = Collections.unmodifiableList(this.x509CRLList);
        return x509CRLs;
    }
}

