/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DSSCannotFetchDataException
extends RuntimeException {
    private static final long serialVersionUID = -1112490792269827445L;
    private ResourceBundle bundle = ResourceBundle.getBundle("eu/europa/esig/dss/i18n");
    private MSG key;
    private Exception cause;
    private String serviceName;

    public DSSCannotFetchDataException(MSG message, String serviceName) {
        if (message == null) {
            throw new IllegalArgumentException("Cannot build Exception without a message");
        }
        this.key = message;
        this.serviceName = serviceName;
    }

    public DSSCannotFetchDataException(IOException ex, String serviceName) {
        this(ex instanceof UnknownHostException ? MSG.UNKNOWN_HOST_EXCEPTION : MSG.IO_EXCEPTION, serviceName);
        this.cause = ex;
        this.serviceName = serviceName;
    }

    @Override
    public String getLocalizedMessage() {
        MessageFormat format = new MessageFormat(this.bundle.getString(this.key.toString()));
        Object[] args = new Object[]{this.serviceName};
        return format.format(args) + (this.cause == null ? "" : " --> " + this.cause.getMessage());
    }

    public static enum MSG {
        IO_EXCEPTION,
        TIMOUT_EXCEPTION,
        SIZE_LIMIT_EXCEPTION,
        UNKNOWN_HOST_EXCEPTION,
        RESOURCE_NOT_FOUND_EXCEPTION;

    }
}

