/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.ResponderId;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.ocsp.ResponseBytes;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSSRevocationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSRevocationUtils.class);
    private static JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();

    private DSSRevocationUtils() {
    }

    public static BasicOCSPResp getBasicOcspResp(DERSequence derSequence) {
        BasicOCSPResp basicOCSPResp = null;
        try {
            BasicOCSPResponse basicOcspResponse = BasicOCSPResponse.getInstance((Object)derSequence);
            basicOCSPResp = new BasicOCSPResp(basicOcspResponse);
        }
        catch (Exception e) {
            LOG.error("Impossible to create BasicOCSPResp from DERSequence!", (Throwable)e);
        }
        return basicOCSPResp;
    }

    public static OCSPResp getOcspResp(DERSequence derSequence) {
        OCSPResp ocspResp = null;
        try {
            OCSPResponse ocspResponse = OCSPResponse.getInstance((Object)derSequence);
            ocspResp = new OCSPResp(ocspResponse);
        }
        catch (Exception e) {
            LOG.error("Impossible to create OCSPResp from DERSequence!", (Throwable)e);
        }
        return ocspResp;
    }

    public static BasicOCSPResp fromRespToBasic(OCSPResp ocspResp) {
        BasicOCSPResp basicOCSPResp = null;
        try {
            Object responseObject = ocspResp.getResponseObject();
            if (responseObject instanceof BasicOCSPResp) {
                basicOCSPResp = (BasicOCSPResp)responseObject;
            } else {
                LOG.warn("Unknown OCSP response type: {}", responseObject.getClass());
            }
        }
        catch (OCSPException e) {
            LOG.error("Impossible to process OCSPResp!", (Throwable)e);
        }
        return basicOCSPResp;
    }

    public static OCSPResp fromBasicToResp(BasicOCSPResp basicOCSPResp) {
        try {
            byte[] encoded = basicOCSPResp.getEncoded();
            return DSSRevocationUtils.fromBasicToResp(encoded);
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static byte[] getEncodedFromBasicResp(BasicOCSPResp basicOCSPResp) {
        try {
            if (basicOCSPResp != null) {
                OCSPResp ocspResp = DSSRevocationUtils.fromBasicToResp(basicOCSPResp);
                return ocspResp.getEncoded();
            }
            throw new DSSException("Empty OCSP response");
        }
        catch (IOException e) {
            throw new DSSException("OCSP encoding error: " + e.getMessage(), (Throwable)e);
        }
    }

    public static OCSPResp fromBasicToResp(byte[] basicOCSPRespBinary) {
        OCSPResponseStatus responseStatus = new OCSPResponseStatus(0);
        DEROctetString derBasicOCSPResp = new DEROctetString(basicOCSPRespBinary);
        ResponseBytes responseBytes = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1OctetString)derBasicOCSPResp);
        OCSPResponse ocspResponse = new OCSPResponse(responseStatus, responseBytes);
        return new OCSPResp(ocspResponse);
    }

    public static boolean matches(CertificateID certId, SingleResp singleResp) {
        CertificateID singleRespCertID = singleResp.getCertID();
        ASN1ObjectIdentifier singleRespCertIDHashAlgOID = singleRespCertID.getHashAlgOID();
        byte[] singleRespCertIDIssuerKeyHash = singleRespCertID.getIssuerKeyHash();
        byte[] singleRespCertIDIssuerNameHash = singleRespCertID.getIssuerNameHash();
        BigInteger singleRespCertIDSerialNumber = singleRespCertID.getSerialNumber();
        ASN1ObjectIdentifier certIdHashAlgOID = certId.getHashAlgOID();
        byte[] certIdIssuerKeyHash = certId.getIssuerKeyHash();
        byte[] certIdIssuerNameHash = certId.getIssuerNameHash();
        BigInteger certIdSerialNumber = certId.getSerialNumber();
        return singleRespCertIDHashAlgOID.equals((Object)certIdHashAlgOID) && Arrays.equals(singleRespCertIDIssuerKeyHash, certIdIssuerKeyHash) && Arrays.equals(singleRespCertIDIssuerNameHash, certIdIssuerNameHash) && singleRespCertIDSerialNumber.equals(certIdSerialNumber);
    }

    public static CertificateID getOCSPCertificateID(CertificateToken cert, CertificateToken issuerCert) {
        try {
            BigInteger serialNumber = cert.getSerialNumber();
            DigestCalculator digestCalculator = DSSRevocationUtils.getSHA1DigestCalculator();
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(issuerCert);
            return new CertificateID(digestCalculator, x509CertificateHolder, serialNumber);
        }
        catch (OCSPException e) {
            throw new DSSException("Unable to create CertificateID", (Throwable)e);
        }
    }

    public static DigestCalculator getSHA1DigestCalculator() {
        try {
            DigestCalculatorProvider digestCalculatorProvider = jcaDigestCalculatorProviderBuilder.build();
            return digestCalculatorProvider.get(CertificateID.HASH_SHA1);
        }
        catch (OperatorCreationException e) {
            throw new DSSException("Unable to create a DigestCalculator instance", (Throwable)e);
        }
    }

    public static BasicOCSPResp loadOCSPBase64Encoded(String base64Encoded) throws IOException {
        byte[] derEncoded = Utils.fromBase64((String)base64Encoded);
        return DSSRevocationUtils.loadOCSPFromBinaries(derEncoded);
    }

    public static BasicOCSPResp loadOCSPFromBinaries(byte[] binaries) throws IOException {
        OCSPResp ocspResp = new OCSPResp(binaries);
        return DSSRevocationUtils.fromRespToBasic(ocspResp);
    }

    public static byte[] getEncoded(OCSPResp ocspResp) {
        try {
            return ocspResp.getEncoded();
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public static ResponderId getDSSResponderId(RespID respID) {
        ResponderId dssResponderId = new ResponderId();
        ResponderID responderIdAsASN1Object = respID.toASN1Primitive();
        DERTaggedObject derTaggedObject = (DERTaggedObject)responderIdAsASN1Object.toASN1Primitive();
        if (2 == derTaggedObject.getTagNo()) {
            ASN1OctetString keyHashOctetString = (ASN1OctetString)derTaggedObject.getObject();
            byte[] keyHashOctetStringBytes = keyHashOctetString.getOctets();
            dssResponderId.setKey(keyHashOctetStringBytes);
            return dssResponderId;
        }
        ASN1Primitive derObject = derTaggedObject.getObject();
        X500Name name = X500Name.getInstance((Object)derObject);
        dssResponderId.setName(name.toString());
        return dssResponderId;
    }

    public static String getJdbcKey(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        StringBuilder buf = new StringBuilder(certificateToken.getEntityKey());
        buf.append(":").append(issuerCertificateToken.getEntityKey());
        return buf.toString();
    }

    public static List<String> getCRLRevocationTokenKeys(CertificateToken certificateToken) {
        List<String> crlUrls = DSSASN1Utils.getCrlUrls(certificateToken);
        ArrayList<String> revocationKeys = new ArrayList<String>();
        for (String crlUrl : crlUrls) {
            revocationKeys.add(DSSRevocationUtils.getCRLRevocationTokenKey(crlUrl));
        }
        return revocationKeys;
    }

    public static String getCRLRevocationTokenKey(String crlUrl) {
        return DSSUtils.getSHA1Digest(crlUrl);
    }

    public static List<String> getOcspRevocationTokenKeys(CertificateToken certificateToken) {
        List<String> ocspUrls = DSSASN1Utils.getOCSPAccessLocations(certificateToken);
        ArrayList<String> revocationKeys = new ArrayList<String>();
        for (String ocspUrl : ocspUrls) {
            revocationKeys.add(DSSRevocationUtils.getOcspRevocationKey(certificateToken, ocspUrl));
        }
        return revocationKeys;
    }

    public static String getOcspRevocationKey(CertificateToken certificateToken, String ocspUrl) {
        return DSSUtils.getSHA1Digest(certificateToken.getEntityKey() + ":" + ocspUrl);
    }
}

