/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.tsl;

import eu.europa.esig.dss.spi.tsl.ServiceInfoStatus;
import eu.europa.esig.dss.spi.util.TimeDependentValues;
import java.io.Serializable;

public class ServiceInfo
implements Serializable {
    private static final long serialVersionUID = 4903410679096343832L;
    private String tlCountryCode;
    private String tspName;
    private String tspTradeName;
    private String tspRegistrationIdentifier;
    private String tspPostalAddress;
    private String tspElectronicAddress;
    private TimeDependentValues<ServiceInfoStatus> status = new TimeDependentValues();

    public String getTlCountryCode() {
        return this.tlCountryCode;
    }

    public TimeDependentValues<ServiceInfoStatus> getStatus() {
        return this.status;
    }

    public String getTspElectronicAddress() {
        return this.tspElectronicAddress;
    }

    public String getTspName() {
        return this.tspName;
    }

    public String getTspRegistrationIdentifier() {
        return this.tspRegistrationIdentifier;
    }

    public String getTspPostalAddress() {
        return this.tspPostalAddress;
    }

    public String getTspTradeName() {
        return this.tspTradeName;
    }

    public void setTlCountryCode(String tlCountryCode) {
        this.tlCountryCode = tlCountryCode;
    }

    public void setTspElectronicAddress(String tspElectronicAddress) {
        this.tspElectronicAddress = this.trim(tspElectronicAddress);
    }

    public void setTspName(String tspName) {
        this.tspName = this.trim(tspName);
    }

    public void setTspRegistrationIdentifier(String tspRegistrationIdentifier) {
        this.tspRegistrationIdentifier = tspRegistrationIdentifier;
    }

    public void setTspPostalAddress(String tspPostalAddress) {
        this.tspPostalAddress = this.trim(tspPostalAddress);
    }

    public void setTspTradeName(String tspTradeName) {
        this.tspTradeName = this.trim(tspTradeName);
    }

    public void setStatus(TimeDependentValues<ServiceInfoStatus> status) {
        this.status = new TimeDependentValues<ServiceInfoStatus>(status);
    }

    private String trim(String str) {
        if (str != null) {
            return str.trim();
        }
        return str;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TSPName                   \t= ").append(this.tspName).append('\n');
        buffer.append("TSPTradeName              \t= ").append(this.tspTradeName).append('\n');
        buffer.append("TSPRegistrationIdentifier \t= ").append(this.tspRegistrationIdentifier).append('\n');
        buffer.append("TSPPostalAddress          \t= ").append(this.tspPostalAddress).append('\n');
        buffer.append("TSPElectronicAddress      \t= ").append(this.tspElectronicAddress).append("\n\n");
        buffer.append("StatusAndExtensions       \t= ").append(this.status).append('\n');
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.tlCountryCode == null ? 0 : this.tlCountryCode.hashCode());
        result = 31 * result + (this.tspElectronicAddress == null ? 0 : this.tspElectronicAddress.hashCode());
        result = 31 * result + (this.tspName == null ? 0 : this.tspName.hashCode());
        result = 31 * result + (this.tspPostalAddress == null ? 0 : this.tspPostalAddress.hashCode());
        result = 31 * result + (this.tspRegistrationIdentifier == null ? 0 : this.tspRegistrationIdentifier.hashCode());
        result = 31 * result + (this.tspTradeName == null ? 0 : this.tspTradeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceInfo other = (ServiceInfo)obj;
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.tlCountryCode == null ? other.tlCountryCode != null : !this.tlCountryCode.equals(other.tlCountryCode)) {
            return false;
        }
        if (this.tspElectronicAddress == null ? other.tspElectronicAddress != null : !this.tspElectronicAddress.equals(other.tspElectronicAddress)) {
            return false;
        }
        if (this.tspName == null ? other.tspName != null : !this.tspName.equals(other.tspName)) {
            return false;
        }
        if (this.tspPostalAddress == null ? other.tspPostalAddress != null : !this.tspPostalAddress.equals(other.tspPostalAddress)) {
            return false;
        }
        if (this.tspRegistrationIdentifier == null ? other.tspRegistrationIdentifier != null : !this.tspRegistrationIdentifier.equals(other.tspRegistrationIdentifier)) {
            return false;
        }
        return !(this.tspTradeName == null ? other.tspTradeName != null : !this.tspTradeName.equals(other.tspTradeName));
    }
}

