/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.util;

import eu.europa.esig.dss.spi.util.TimeDependent;
import eu.europa.esig.dss.spi.util.TimeDependentValues;
import java.util.Date;
import java.util.List;

public class MutableTimeDependentValues<T extends TimeDependent>
extends TimeDependentValues<T> {
    public MutableTimeDependentValues() {
    }

    public MutableTimeDependentValues(Iterable<T> srcList) {
        super(srcList);
    }

    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized void addOldest(T x) {
        if (x == null) {
            throw new NullPointerException("Cannot add null");
        }
        if (!this.list.isEmpty()) {
            Date endDate = x.getEndDate();
            for (TimeDependent y : this.list) {
                if (endDate.compareTo(y.getStartDate()) <= 0) continue;
                throw new IllegalArgumentException("Cannot add overlapping item");
            }
        }
        this.list.add(x);
    }

    public List<T> getList() {
        return this.list;
    }
}

