/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.CertificatePoolEntity;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatePool
implements Serializable {
    private static final long serialVersionUID = -3933224032299663242L;
    private static final Logger LOG = LoggerFactory.getLogger(CertificatePool.class);
    private Map<String, CertificatePoolEntity> entriesByPublicKeyHash = new HashMap<String, CertificatePoolEntity>();
    private Map<String, Set<CertificateToken>> tokensBySubject = new HashMap<String, Set<CertificateToken>>();

    public CertificatePool() {
        LOG.debug("New CertificatePool created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateToken getInstance(CertificateToken certificateToAdd, CertificateSourceType certSource) {
        Objects.requireNonNull(certificateToAdd, "The certificate must be filled");
        Objects.requireNonNull(certSource, "The certificate source type must be set.");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Certificate to add: {} | {}", (Object)certificateToAdd.getIssuerX500Principal(), (Object)certificateToAdd.getSerialNumber());
        }
        Map<String, Object> map = this.entriesByPublicKeyHash;
        synchronized (map) {
            String entityKey = certificateToAdd.getEntityKey();
            CertificatePoolEntity poolEntity = this.entriesByPublicKeyHash.get(entityKey);
            if (poolEntity == null) {
                LOG.trace("Public key {} is not in the pool", (Object)entityKey);
                poolEntity = new CertificatePoolEntity(certificateToAdd, certSource);
                this.entriesByPublicKeyHash.put(entityKey, poolEntity);
            } else {
                LOG.trace("Public key {} is already in the pool", (Object)entityKey);
                poolEntity.addEquivalentCertificate(certificateToAdd);
                poolEntity.addSource(certSource);
            }
        }
        map = this.tokensBySubject;
        synchronized (map) {
            String canonicalizedSubject = certificateToAdd.getCanonicalizedSubject();
            Set<CertificateToken> tokensSet = this.tokensBySubject.get(canonicalizedSubject);
            if (tokensSet == null) {
                tokensSet = new HashSet<CertificateToken>();
                this.tokensBySubject.put(canonicalizedSubject, tokensSet);
            }
            tokensSet.add(certificateToAdd);
        }
        return certificateToAdd;
    }

    public boolean isTrusted(CertificateToken cert) {
        CertificatePoolEntity poolEntity = this.getPoolEntry(cert);
        return poolEntity != null && poolEntity.isTrusted();
    }

    public Set<CertificateSourceType> getSources(CertificateToken certificateToken) {
        CertificatePoolEntity poolEntity = this.getPoolEntry(certificateToken);
        if (poolEntity != null) {
            return poolEntity.getSources();
        }
        return Collections.emptySet();
    }

    public List<CertificateToken> getIssuers(Token token) {
        if (token.getPublicKeyOfTheSigner() != null) {
            return this.get(token.getPublicKeyOfTheSigner());
        }
        if (token.getIssuerX500Principal() != null) {
            Set<CertificateToken> potentialIssuers = this.get(token.getIssuerX500Principal());
            for (CertificateToken potentialIssuer : potentialIssuers) {
                if (!token.isSignedBy(potentialIssuer)) continue;
                return this.get(potentialIssuer.getPublicKey());
            }
        }
        return Collections.emptyList();
    }

    public CertificateToken getIssuer(Token token) {
        List<CertificateToken> issuers = this.getIssuers(token);
        if (Utils.isCollectionNotEmpty(issuers)) {
            for (CertificateToken issuer : issuers) {
                if (!issuer.isValidOn(token.getCreationDate())) continue;
                return issuer;
            }
            LOG.warn("No issuer found for the token creation date. The process continues with an issuer which has the same public key.");
            return issuers.iterator().next();
        }
        return null;
    }

    public CertificateToken getTrustAnchor(CertificateToken cert) {
        CertificatePoolEntity poolEntity = this.getPoolEntry(cert);
        while (poolEntity != null) {
            List<CertificateToken> certificates = poolEntity.getEquivalentCertificates();
            if (poolEntity.isTrusted()) {
                return certificates.iterator().next();
            }
            ArrayList<PublicKey> pubKeyIssuers = new ArrayList<PublicKey>();
            for (CertificateToken certificateToken : certificates) {
                if (certificateToken.isSelfIssued() || certificateToken.getPublicKeyOfTheSigner() == null) continue;
                pubKeyIssuers.add(certificateToken.getPublicKeyOfTheSigner());
            }
            if (pubKeyIssuers.isEmpty()) continue;
            if (pubKeyIssuers.size() > 1) {
                LOG.warn("More than one path found");
            }
            poolEntity = this.getPoolEntry((PublicKey)pubKeyIssuers.iterator().next());
        }
        return null;
    }

    public Set<CertificateToken> get(X500Principal x500Principal) {
        Set<CertificateToken> tokensSet = this.tokensBySubject.get(this.canonicalize(x500Principal));
        if (tokensSet != null) {
            return tokensSet;
        }
        return Collections.emptySet();
    }

    public List<CertificateToken> get(PublicKey publicKey) {
        CertificatePoolEntity poolEntity = this.entriesByPublicKeyHash.get(this.getPublicKeyHash(publicKey));
        if (poolEntity != null) {
            return poolEntity.getEquivalentCertificates();
        }
        return Collections.emptyList();
    }

    public List<CertificateToken> getBySki(byte[] expectedSki) {
        Collection<CertificatePoolEntity> values = this.entriesByPublicKeyHash.values();
        for (CertificatePoolEntity entity : values) {
            if (!Arrays.equals(expectedSki, entity.getSki())) continue;
            return entity.getEquivalentCertificates();
        }
        return Collections.emptyList();
    }

    public List<CertificateToken> getBySignerId(SignerId signerId) {
        Collection<CertificatePoolEntity> values = this.entriesByPublicKeyHash.values();
        for (CertificatePoolEntity entity : values) {
            List<CertificateToken> equivalentCertificates = entity.getEquivalentCertificates();
            CertificateToken token = equivalentCertificates.iterator().next();
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(token);
            CollectionStore store = new CollectionStore(Collections.singleton(x509CertificateHolder));
            Collection matches = store.getMatches((Selector)signerId);
            if (matches.isEmpty()) continue;
            return equivalentCertificates;
        }
        return Collections.emptyList();
    }

    private CertificatePoolEntity getPoolEntry(CertificateToken cert) {
        return this.entriesByPublicKeyHash.get(cert.getEntityKey());
    }

    private CertificatePoolEntity getPoolEntry(PublicKey pubKey) {
        return this.entriesByPublicKeyHash.get(this.getPublicKeyHash(pubKey));
    }

    private String getPublicKeyHash(PublicKey pk) {
        EntityIdentifier id = new EntityIdentifier(pk);
        return id.asXmlId();
    }

    private String canonicalize(X500Principal x500Principal) {
        return x500Principal.getName("CANONICAL");
    }

    public void importCerts(CertificateSource certificateSource) {
        List<CertificateToken> unmodifiableList = certificateSource.getCertificates();
        CertificateSourceType source = certificateSource.getCertificateSourceType();
        for (CertificateToken certificateToImport : unmodifiableList) {
            this.getInstance(certificateToImport, source);
        }
    }

    public int getNumberOfEntities() {
        return this.entriesByPublicKeyHash.size();
    }

    public int getNumberOfCertificates() {
        int i = 0;
        for (CertificatePoolEntity entity : this.entriesByPublicKeyHash.values()) {
            i += entity.getEquivalentCertificates().size();
        }
        return i;
    }

    public List<CertificateToken> getCertificateTokens() {
        ArrayList<CertificateToken> certs = new ArrayList<CertificateToken>();
        for (CertificatePoolEntity entity : this.entriesByPublicKeyHash.values()) {
            certs.addAll(entity.getEquivalentCertificates());
        }
        return certs;
    }
}

