/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.revocation.RepositoryRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationException;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcRevocationSource<T extends RevocationToken>
extends RepositoryRevocationSource<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRevocationSource.class);
    private static final long serialVersionUID = 8752226611048306095L;
    protected transient DataSource dataSource;

    protected abstract String getCreateTableQuery();

    protected abstract String getTableExistenceQuery();

    protected abstract String getFindRevocationQuery();

    protected abstract String getDeleteTableQuery();

    protected abstract String getRemoveRevocationTokenEntryQuery();

    protected abstract T buildRevocationTokenFromResult(ResultSet var1, CertificateToken var2, CertificateToken var3) throws RevocationException;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T findRevocation(String key, CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        ResultSet rs;
        PreparedStatement s;
        Connection c;
        block5: {
            c = null;
            s = null;
            rs = null;
            c = this.dataSource.getConnection();
            s = c.prepareStatement(this.getFindRevocationQuery());
            s.setString(1, key);
            rs = s.executeQuery();
            if (!rs.next()) break block5;
            T t = this.buildRevocationTokenFromResult(rs, certificateToken, issuerCertificateToken);
            this.closeQuietly(c, s, rs);
            return t;
        }
        try {
            c.commit();
            this.closeQuietly(c, s, rs);
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to select CRL from the DB", (Throwable)e);
                this.rollback(c);
                this.closeQuietly(c, s, rs);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s, rs);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeRevocation(T token) {
        Connection c = null;
        PreparedStatement s = null;
        try {
            c = this.dataSource.getConnection();
            s = c.prepareStatement(this.getRemoveRevocationTokenEntryQuery());
            s.setString(1, ((RevocationToken)((Object)token)).getRevocationTokenKey());
            s.executeUpdate();
            c.commit();
            LOG.debug("Revocation token with key '{}' successfully removed from DB", (Object)((RevocationToken)((Object)token)).getRevocationTokenKey());
            this.closeQuietly(c, s, null);
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to remove Revocation token from the DB", (Throwable)e);
                this.rollback(c);
                this.closeQuietly(c, s, null);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s, null);
                throw throwable;
            }
        }
    }

    public void initTable() throws SQLException {
        if (!this.isTableExists()) {
            LOG.debug("Table does not exist. Creating a new table...");
            this.createTable();
            LOG.info("Table was created.");
        } else {
            LOG.debug("Table already exists.");
        }
    }

    private void createTable() throws SQLException {
        Connection c = null;
        Statement s = null;
        try {
            c = this.dataSource.getConnection();
            s = c.createStatement();
            s.executeUpdate(this.getCreateTableQuery());
            c.commit();
        }
        catch (SQLException e) {
            this.rollback(c);
            throw e;
        }
        finally {
            this.closeQuietly(c, s, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExists() {
        boolean tableExists;
        Connection c = null;
        Statement s = null;
        try {
            c = this.dataSource.getConnection();
            s = c.createStatement();
            tableExists = s.execute(this.getTableExistenceQuery());
        }
        catch (SQLException e) {
            tableExists = false;
        }
        finally {
            this.closeQuietly(c, s, null);
        }
        return tableExists;
    }

    public void destroyTable() throws SQLException {
        if (this.isTableExists()) {
            LOG.debug("Table exists. Removing the table...");
            this.dropTable();
            LOG.info("Table was destroyed.");
        } else {
            LOG.warn("Cannot drop the table. Table does not exist.");
        }
    }

    private void dropTable() throws SQLException {
        Connection c = null;
        Statement s = null;
        try {
            c = this.dataSource.getConnection();
            s = c.createStatement();
            s.execute(this.getDeleteTableQuery());
            c.commit();
        }
        catch (SQLException e) {
            this.rollback(c);
            throw e;
        }
        finally {
            this.closeQuietly(c, s, null);
        }
    }

    protected void rollback(Connection c) {
        if (c != null) {
            try {
                LOG.warn("Transaction is being rolled back");
                c.rollback();
            }
            catch (SQLException e) {
                LOG.error("Unable to rollback", (Throwable)e);
            }
        }
    }

    protected void closeQuietly(Connection c, Statement s, ResultSet rs) {
        this.closeQuietly(rs);
        this.closeQuietly(s);
        this.closeQuietly(c);
    }

    private void closeQuietly(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeQuietly(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeQuietly(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

