/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfflineCRLSource
implements CRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineCRLSource.class);
    private final Map<CRLBinary, Set<RevocationOrigin>> crlBinaryOriginsMap = new HashMap<CRLBinary, Set<RevocationOrigin>>();
    private Map<String, CRLValidity> crlValidityMap = new HashMap<String, CRLValidity>();
    private Map<CertificateToken, CRLToken> validCRLTokenList = new HashMap<CertificateToken, CRLToken>();

    @Override
    public final CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (certificateToken == null) {
            throw new NullPointerException();
        }
        CRLToken validCRLToken = this.validCRLTokenList.get(certificateToken);
        if (validCRLToken != null) {
            return validCRLToken;
        }
        if (issuerToken == null) {
            return null;
        }
        CRLValidity bestCRLValidity = this.getBestCrlValidityEntry(certificateToken, issuerToken);
        if (bestCRLValidity == null) {
            return null;
        }
        CRLToken crlToken = new CRLToken(certificateToken, bestCRLValidity);
        this.validCRLTokenList.put(certificateToken, crlToken);
        this.storeCRLToken(bestCRLValidity.getCrlBinaryIdentifier(), crlToken);
        crlToken.setOrigins(this.getRevocationOrigins(bestCRLValidity.getCrlBinaryIdentifier()));
        return crlToken;
    }

    private CRLValidity getBestCrlValidityEntry(CertificateToken certificateToken, CertificateToken issuerToken) {
        CRLValidity bestCRLValidity = null;
        Date bestX509UpdateDate = null;
        for (CRLBinary crlEntry : this.crlBinaryOriginsMap.keySet()) {
            boolean periodAreIntersecting;
            CRLValidity crlValidity = this.getCrlValidity(crlEntry, issuerToken);
            if (crlValidity == null || !crlValidity.isValid()) continue;
            Date thisUpdate = crlValidity.getThisUpdate();
            Date nextUpdate = crlValidity.getNextUpdate();
            Date notAfter = certificateToken.getNotAfter();
            Date notBefore = certificateToken.getNotBefore();
            boolean bl = periodAreIntersecting = thisUpdate.before(notAfter) && nextUpdate != null && nextUpdate.after(notBefore);
            if (!periodAreIntersecting) {
                LOG.warn("The CRL was not issued during the validity period of the certificate! Certificate: {}", (Object)certificateToken.getDSSIdAsString());
                continue;
            }
            if (bestX509UpdateDate != null && !thisUpdate.after(bestX509UpdateDate)) continue;
            bestCRLValidity = crlValidity;
            bestX509UpdateDate = thisUpdate;
        }
        return bestCRLValidity;
    }

    private CRLValidity getCrlValidity(CRLBinary crlBinary, CertificateToken issuerToken) {
        String crlValidityKey = this.getCrlValidityKey(crlBinary, issuerToken);
        CRLValidity crlValidity = this.crlValidityMap.get(crlValidityKey);
        if (crlValidity == null) {
            try {
                crlValidity = CRLUtils.buildCRLValidity((CRLBinary)crlBinary, (CertificateToken)issuerToken);
                if (crlValidity.isValid()) {
                    this.crlValidityMap.put(crlValidityKey, crlValidity);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to parse CRL", (Throwable)e);
            }
        }
        return crlValidity;
    }

    protected CRLBinary addCRLBinary(byte[] binaries, RevocationOrigin origin) {
        CRLBinary crlBinary = new CRLBinary(binaries);
        this.addCRLBinary(crlBinary, origin);
        return crlBinary;
    }

    protected void addCRLBinary(CRLBinary crlBinary, RevocationOrigin origin) {
        Set<RevocationOrigin> origins = this.crlBinaryOriginsMap.get(crlBinary);
        if (origins == null) {
            origins = new HashSet<RevocationOrigin>();
            this.crlBinaryOriginsMap.put(crlBinary, origins);
        }
        origins.add(origin);
    }

    private String getCrlValidityKey(CRLBinary crlBinary, CertificateToken issuerToken) {
        return crlBinary.asXmlId() + issuerToken.getDSSIdAsString();
    }

    public Collection<CRLBinary> getCRLBinaryList() {
        return Collections.unmodifiableCollection(this.crlBinaryOriginsMap.keySet());
    }

    public boolean isEmpty() {
        return Utils.isMapEmpty(this.crlBinaryOriginsMap);
    }

    protected void storeCRLToken(CRLBinary crlBinary, CRLToken crlToken) {
    }

    public CRLBinary getIdentifier(CRLRef crlRef) {
        return this.getIdentifier(crlRef.getDigest());
    }

    public CRLBinary getIdentifier(Digest digest) {
        for (CRLBinary crlBinary : this.crlBinaryOriginsMap.keySet()) {
            byte[] digestValue = crlBinary.getDigestValue(digest.getAlgorithm());
            if (!Arrays.equals(digest.getValue(), digestValue)) continue;
            return crlBinary;
        }
        return null;
    }

    public Set<RevocationOrigin> getRevocationOrigins(CRLBinary crlBinary) {
        return this.crlBinaryOriginsMap.get(crlBinary);
    }
}

