/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import java.io.InputStream;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class ExternalResourcesOCSPSource
extends OfflineOCSPSource {
    public ExternalResourcesOCSPSource(String ... paths) {
        for (String pathItem : paths) {
            this.load(this.getClass().getResourceAsStream(pathItem));
        }
    }

    public ExternalResourcesOCSPSource(InputStream ... inputStreams) {
        for (InputStream inputStream : inputStreams) {
            this.load(inputStream);
        }
    }

    private void load(InputStream inputStream) {
        try (InputStream is = inputStream;){
            OCSPResp ocspResp = new OCSPResp(is);
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)ocspResp.getResponseObject();
            this.addOCSPResponse(OCSPResponseBinary.build(basicOCSPResp), RevocationOrigin.EXTERNAL);
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    @Override
    public void appendContainedOCSPResponses() {
    }
}

