/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPResponseBinary
extends EncapsulatedRevocationTokenIdentifier {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPResponseBinary.class);
    private static final long serialVersionUID = 6693521503459405568L;
    private final transient BasicOCSPResp basicOCSPResp;
    private transient ASN1ObjectIdentifier asn1ObjectIdentifier;

    public static OCSPResponseBinary build(BasicOCSPResp basicOCSPResp) {
        byte[] ocspRespBinary = DSSRevocationUtils.getEncodedFromBasicResp(basicOCSPResp);
        return new OCSPResponseBinary(basicOCSPResp, ocspRespBinary);
    }

    OCSPResponseBinary(BasicOCSPResp basicOCSPResp, byte[] encoded) {
        super(encoded);
        this.basicOCSPResp = basicOCSPResp;
    }

    public BasicOCSPResp getBasicOCSPResp() {
        return this.basicOCSPResp;
    }

    public byte[] getBasicOCSPRespContent() {
        try {
            return this.basicOCSPResp.getEncoded();
        }
        catch (IOException e) {
            LOG.warn("Cannot get content bytes from BasicOCSPResponse of OCSPResponseIdentifier with id [{}]. Reason: [{}]", (Object)this.asXmlId(), (Object)e.getMessage());
            return DSSUtils.EMPTY_BYTE_ARRAY;
        }
    }

    public ASN1ObjectIdentifier getAsn1ObjectIdentifier() {
        return this.asn1ObjectIdentifier;
    }

    public void setAsn1ObjectIdentifier(ASN1ObjectIdentifier asn1ObjectIdentifier) {
        this.asn1ObjectIdentifier = asn1ObjectIdentifier;
    }
}

