/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.tsp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTSPSource
implements TSPSource {
    private static final long serialVersionUID = 948088043702414489L;
    private static final Logger LOG = LoggerFactory.getLogger(CompositeTSPSource.class);
    private Map<String, TSPSource> tspSources;

    public void setTspSources(Map<String, TSPSource> tspSources) {
        this.tspSources = tspSources;
    }

    @Override
    public TimestampBinary getTimeStampResponse(DigestAlgorithm digestAlgorithm, byte[] digestValue) throws DSSException {
        for (Map.Entry<String, TSPSource> entry : this.tspSources.entrySet()) {
            String sourceKey = entry.getKey();
            TSPSource source = entry.getValue();
            LOG.debug("Trying to get timestamp with TSPSource '{}'", (Object)sourceKey);
            try {
                TimestampBinary timestampBinary = source.getTimeStampResponse(digestAlgorithm, digestValue);
                if (timestampBinary == null) continue;
                LOG.debug("Successfully retrieved timestamp with TSPSource '{}'", (Object)sourceKey);
                return timestampBinary;
            }
            catch (Exception e) {
                LOG.warn("Unable to retrieve the timestamp with TSPSource '{}' : {}", (Object)sourceKey, (Object)e.getMessage());
            }
        }
        throw new DSSException("Unable to retrieve the timestamp (" + this.tspSources.size() + " tries)");
    }
}

