/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.security.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureTokenConnection
implements SignatureTokenConnection {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSignatureTokenConnection.class);

    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        if (!(keyEntry instanceof KSPrivateKeyEntry)) {
            throw new IllegalArgumentException("Only KSPrivateKeyEntry are supported");
        }
        EncryptionAlgorithm encryptionAlgorithm = keyEntry.getEncryptionAlgorithm();
        LOG.info("Signature algorithm: " + encryptionAlgorithm + "/" + digestAlgorithm);
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm);
        String javaSignatureAlgorithm = signatureAlgorithm.getJCEId();
        try {
            Signature signature = Signature.getInstance(javaSignatureAlgorithm);
            signature.initSign(((KSPrivateKeyEntry)keyEntry).getPrivateKey());
            signature.update(toBeSigned.getBytes());
            byte[] signatureValue = signature.sign();
            SignatureValue value = new SignatureValue();
            value.setAlgorithm(signatureAlgorithm);
            value.setValue(signatureValue);
            return value;
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }
}

