/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.service;

import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.tsl.TSLLoaderResult;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSLLoader
implements Callable<TSLLoaderResult> {
    private static final Logger LOG = LoggerFactory.getLogger(TSLLoader.class);
    private DataLoader dataLoader;
    private String countryCode;
    private String urlToLoad;

    public TSLLoader(DataLoader dataLoader, String countryCode, String urlToLoad) {
        this.dataLoader = dataLoader;
        this.countryCode = countryCode;
        this.urlToLoad = urlToLoad;
    }

    @Override
    public TSLLoaderResult call() throws Exception {
        TSLLoaderResult result = new TSLLoaderResult();
        result.setCountryCode(this.countryCode);
        result.setUrl(this.urlToLoad);
        try {
            byte[] byteArray = this.dataLoader.get(this.urlToLoad);
            result.setContent(byteArray);
        }
        catch (Exception e) {
            LOG.warn("Unable to load '" + this.urlToLoad + "' : " + e.getMessage());
        }
        return result;
    }
}

