/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.service;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.tsl.CertSubjectDNAttributeCondition;
import eu.europa.esig.dss.tsl.CompositeCondition;
import eu.europa.esig.dss.tsl.Condition;
import eu.europa.esig.dss.tsl.ExtendedKeyUsageCondition;
import eu.europa.esig.dss.tsl.KeyUsageCondition;
import eu.europa.esig.dss.tsl.MatchingCriteriaIndicator;
import eu.europa.esig.dss.tsl.PolicyIdCondition;
import eu.europa.esig.dss.tsl.TSLConditionsForQualifiers;
import eu.europa.esig.dss.tsl.TSLParserResult;
import eu.europa.esig.dss.tsl.TSLPointer;
import eu.europa.esig.dss.tsl.TSLService;
import eu.europa.esig.dss.tsl.TSLServiceProvider;
import eu.europa.esig.dss.tsl.TSLServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.util.MutableTimeDependentValues;
import eu.europa.esig.dss.util.TimeDependent;
import eu.europa.esig.dss.util.TimeDependentValues;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.jaxb.ecc.CriteriaListType;
import eu.europa.esig.jaxb.ecc.KeyUsageBitType;
import eu.europa.esig.jaxb.ecc.KeyUsageType;
import eu.europa.esig.jaxb.ecc.PoliciesListType;
import eu.europa.esig.jaxb.ecc.QualificationElementType;
import eu.europa.esig.jaxb.ecc.QualificationsType;
import eu.europa.esig.jaxb.ecc.QualifierType;
import eu.europa.esig.jaxb.ecc.QualifiersType;
import eu.europa.esig.jaxb.tsl.AdditionalServiceInformationType;
import eu.europa.esig.jaxb.tsl.AnyType;
import eu.europa.esig.jaxb.tsl.DigitalIdentityListType;
import eu.europa.esig.jaxb.tsl.DigitalIdentityType;
import eu.europa.esig.jaxb.tsl.ExtensionType;
import eu.europa.esig.jaxb.tsl.ExtensionsListType;
import eu.europa.esig.jaxb.tsl.InternationalNamesType;
import eu.europa.esig.jaxb.tsl.MultiLangNormStringType;
import eu.europa.esig.jaxb.tsl.NextUpdateType;
import eu.europa.esig.jaxb.tsl.NonEmptyMultiLangURIListType;
import eu.europa.esig.jaxb.tsl.NonEmptyMultiLangURIType;
import eu.europa.esig.jaxb.tsl.NonEmptyURIListType;
import eu.europa.esig.jaxb.tsl.ObjectFactory;
import eu.europa.esig.jaxb.tsl.OtherTSLPointerType;
import eu.europa.esig.jaxb.tsl.PostalAddressType;
import eu.europa.esig.jaxb.tsl.ServiceHistoryInstanceType;
import eu.europa.esig.jaxb.tsl.ServiceSupplyPointsType;
import eu.europa.esig.jaxb.tsl.TSPInformationType;
import eu.europa.esig.jaxb.tsl.TSPServiceInformationType;
import eu.europa.esig.jaxb.tsl.TSPServiceType;
import eu.europa.esig.jaxb.tsl.TSPServicesListType;
import eu.europa.esig.jaxb.tsl.TSPType;
import eu.europa.esig.jaxb.tsl.TrustServiceProviderListType;
import eu.europa.esig.jaxb.tsl.TrustStatusListType;
import eu.europa.esig.jaxb.tslx.CertSubjectDNAttributeType;
import eu.europa.esig.jaxb.tslx.ExtendedKeyUsageType;
import eu.europa.esig.jaxb.xades.IdentifierType;
import eu.europa.esig.jaxb.xades.ObjectIdentifierType;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TSLParser
implements Callable<TSLParserResult> {
    private static final Logger LOG = LoggerFactory.getLogger(TSLParser.class);
    private static final String ENGLISH_LANGUAGE = "en";
    private static final String TSL_MIME_TYPE = "application/vnd.etsi.tsl+xml";
    private static final JAXBContext jaxbContext;
    private String filepath;

    public TSLParser(String filepath) {
        this.filepath = filepath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TSLParserResult call() throws Exception {
        try (FileInputStream is = new FileInputStream(this.filepath);){
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement jaxbElement = (JAXBElement)unmarshaller.unmarshal((InputStream)is);
            TrustStatusListType trustStatusList = (TrustStatusListType)jaxbElement.getValue();
            TSLParserResult tSLParserResult = this.getTslModel(trustStatusList);
            return tSLParserResult;
        }
        catch (Exception e) {
            throw new DSSException("Unable to parse file '" + this.filepath + "' : " + e.getMessage(), (Throwable)e);
        }
    }

    private TSLParserResult getTslModel(TrustStatusListType tsl) {
        TSLParserResult tslModel = new TSLParserResult();
        tslModel.setTerritory(this.getTerritory(tsl));
        tslModel.setSequenceNumber(this.getSequenceNumber(tsl));
        tslModel.setVersion(this.getVersion(tsl));
        tslModel.setIssueDate(this.getIssueDate(tsl));
        tslModel.setNextUpdateDate(this.getNextUpdate(tsl));
        tslModel.setDistributionPoints(this.getDistributionPoints(tsl));
        tslModel.setPointers(this.getMachineProcessableTSLPointers(tsl));
        tslModel.setServiceProviders(this.getServiceProviders(tsl));
        tslModel.setEnglishSchemeInformationURIs(this.getEnglishSchemeInformationURIs(tsl));
        return tslModel;
    }

    private int getVersion(TrustStatusListType tsl) {
        BigInteger tslVersionIdentifier = tsl.getSchemeInformation().getTSLVersionIdentifier();
        if (tslVersionIdentifier != null) {
            return tslVersionIdentifier.intValue();
        }
        return -1;
    }

    private int getSequenceNumber(TrustStatusListType tsl) {
        BigInteger tslSequenceNumber = tsl.getSchemeInformation().getTSLSequenceNumber();
        if (tslSequenceNumber != null) {
            return tslSequenceNumber.intValue();
        }
        return -1;
    }

    private String getTerritory(TrustStatusListType tsl) {
        return tsl.getSchemeInformation().getSchemeTerritory();
    }

    private Date getIssueDate(TrustStatusListType tsl) {
        XMLGregorianCalendar gregorianCalendar = tsl.getSchemeInformation().getListIssueDateTime();
        return this.convertToDate(gregorianCalendar);
    }

    private Date getNextUpdate(TrustStatusListType tsl) {
        NextUpdateType nextUpdate = tsl.getSchemeInformation().getNextUpdate();
        if (nextUpdate != null) {
            return this.convertToDate(nextUpdate.getDateTime());
        }
        return null;
    }

    private List<String> getDistributionPoints(TrustStatusListType tsl) {
        NonEmptyURIListType distributionPoints = tsl.getSchemeInformation().getDistributionPoints();
        if (distributionPoints != null) {
            return distributionPoints.getURI();
        }
        return new ArrayList<String>();
    }

    private Date convertToDate(XMLGregorianCalendar gregorianCalendar) {
        GregorianCalendar toGregorianCalendar;
        if (gregorianCalendar != null && (toGregorianCalendar = gregorianCalendar.toGregorianCalendar()) != null) {
            return toGregorianCalendar.getTime();
        }
        return null;
    }

    private List<TSLPointer> getMachineProcessableTSLPointers(TrustStatusListType tsl) {
        ArrayList<TSLPointer> list = new ArrayList<TSLPointer>();
        List<TSLPointer> tslPointers = this.getTSLPointers(tsl);
        if (Utils.isCollectionNotEmpty(tslPointers)) {
            for (TSLPointer tslPointer : tslPointers) {
                if (!TSL_MIME_TYPE.equals(tslPointer.getMimeType())) continue;
                list.add(tslPointer);
            }
        }
        return list;
    }

    private List<TSLPointer> getTSLPointers(TrustStatusListType tsl) {
        ArrayList<TSLPointer> list = new ArrayList<TSLPointer>();
        if (tsl.getSchemeInformation() != null && tsl.getSchemeInformation().getPointersToOtherTSL() != null) {
            List pointers = tsl.getSchemeInformation().getPointersToOtherTSL().getOtherTSLPointer();
            for (OtherTSLPointerType otherTSLPointerType : pointers) {
                list.add(this.getPointerInfos(otherTSLPointerType));
            }
        }
        return list;
    }

    private TSLPointer getPointerInfos(OtherTSLPointerType otherTSLPointerType) {
        TSLPointer pointer = new TSLPointer();
        pointer.setUrl(otherTSLPointerType.getTSLLocation());
        pointer.setPotentialSigners(this.getPotentialSigners(otherTSLPointerType));
        this.fillPointerTerritoryAndMimeType(otherTSLPointerType, pointer);
        return pointer;
    }

    private void fillPointerTerritoryAndMimeType(OtherTSLPointerType otherTSLPointerType, TSLPointer pointer) {
        List textualInformationOrOtherInformation = otherTSLPointerType.getAdditionalInformation().getTextualInformationOrOtherInformation();
        if (Utils.isCollectionNotEmpty((Collection)textualInformationOrOtherInformation)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Serializable serializable : textualInformationOrOtherInformation) {
                if (!(serializable instanceof AnyType)) continue;
                AnyType anyInfo = (AnyType)serializable;
                for (Object content : anyInfo.getContent()) {
                    if (content instanceof JAXBElement) {
                        JAXBElement jaxbElement = (JAXBElement)content;
                        properties.put(jaxbElement.getName().toString(), jaxbElement.getValue().toString());
                        continue;
                    }
                    if (!(content instanceof Element)) continue;
                    Element element = (Element)content;
                    properties.put("{" + element.getNamespaceURI() + "}" + element.getLocalName(), element.getTextContent());
                }
            }
            pointer.setMimeType((String)properties.get("{http://uri.etsi.org/02231/v2/additionaltypes#}MimeType"));
            pointer.setTerritory((String)properties.get("{http://uri.etsi.org/02231/v2#}SchemeTerritory"));
        }
    }

    private List<CertificateToken> getPotentialSigners(OtherTSLPointerType otherTSLPointerType) {
        ArrayList<CertificateToken> list = new ArrayList<CertificateToken>();
        if (otherTSLPointerType.getServiceDigitalIdentities() != null) {
            List serviceDigitalIdentity = otherTSLPointerType.getServiceDigitalIdentities().getServiceDigitalIdentity();
            this.extractCertificates(serviceDigitalIdentity, list);
        }
        return list;
    }

    private void extractCertificates(List<DigitalIdentityListType> serviceDigitalIdentity, List<CertificateToken> result) {
        for (DigitalIdentityListType digitalIdentityListType : serviceDigitalIdentity) {
            List<CertificateToken> certificates = this.extractCertificates(digitalIdentityListType);
            if (!Utils.isCollectionNotEmpty(certificates)) continue;
            result.addAll(certificates);
        }
    }

    private List<CertificateToken> extractCertificates(DigitalIdentityListType digitalIdentityListType) {
        ArrayList<CertificateToken> certificates = new ArrayList<CertificateToken>();
        List digitalIds = digitalIdentityListType.getDigitalId();
        for (DigitalIdentityType digitalId : digitalIds) {
            if (digitalId.getX509Certificate() == null) continue;
            try {
                CertificateToken certificate = DSSUtils.loadCertificate((byte[])digitalId.getX509Certificate());
                certificates.add(certificate);
            }
            catch (Exception e) {
                LOG.warn("Unable to load certificate : " + e.getMessage(), (Throwable)e);
            }
        }
        return certificates;
    }

    private List<TSLServiceProvider> getServiceProviders(TrustStatusListType tsl) {
        ArrayList<TSLServiceProvider> serviceProviders = new ArrayList<TSLServiceProvider>();
        TrustServiceProviderListType trustServiceProviderList = tsl.getTrustServiceProviderList();
        if (trustServiceProviderList != null && Utils.isCollectionNotEmpty((Collection)trustServiceProviderList.getTrustServiceProvider())) {
            for (TSPType tsp : trustServiceProviderList.getTrustServiceProvider()) {
                serviceProviders.add(this.getServiceProvider(tsp));
            }
        }
        return serviceProviders;
    }

    private TSLServiceProvider getServiceProvider(TSPType tsp) {
        TSLServiceProvider serviceProvider = new TSLServiceProvider();
        TSPInformationType tspInformation = tsp.getTSPInformation();
        if (tspInformation != null) {
            serviceProvider.setName(this.getEnglishOrFirst(tspInformation.getTSPName()));
            serviceProvider.setTradeName(this.getEnglishOrFirst(tspInformation.getTSPTradeName()));
            serviceProvider.setPostalAddress(this.getPostalAddress(tspInformation));
            serviceProvider.setElectronicAddress(this.getElectronicAddress(tspInformation));
            serviceProvider.setServices(this.getServices(tsp.getTSPServices()));
        }
        return serviceProvider;
    }

    private List<TSLService> getServices(TSPServicesListType tspServices) {
        ArrayList<TSLService> services = new ArrayList<TSLService>();
        if (tspServices != null && Utils.isCollectionNotEmpty((Collection)tspServices.getTSPService())) {
            for (TSPServiceType tslService : tspServices.getTSPService()) {
                if (tslService.getServiceInformation() == null) continue;
                services.add(this.getService(tslService));
            }
        }
        return services;
    }

    private TSLService getService(TSPServiceType tslService) {
        TSLService service = new TSLService();
        TSPServiceInformationType serviceInfo = tslService.getServiceInformation();
        service.setName(this.getEnglishOrFirst(serviceInfo.getServiceName()));
        service.setCertificates(this.extractCertificates(serviceInfo.getServiceDigitalIdentity()));
        service.setStatusAndInformationExtensions(this.getStatusHistory(tslService));
        return service;
    }

    private List<String> getServiceSupplyPoints(ServiceSupplyPointsType serviceSupplyPoints) {
        if (serviceSupplyPoints == null) {
            return new ArrayList<String>();
        }
        return serviceSupplyPoints.getServiceSupplyPoint();
    }

    private TimeDependentValues<TSLServiceStatusAndInformationExtensions> getStatusHistory(TSPServiceType tslService) {
        MutableTimeDependentValues statusHistoryList = new MutableTimeDependentValues();
        TSPServiceInformationType serviceInfo = tslService.getServiceInformation();
        TSLServiceStatusAndInformationExtensions status = new TSLServiceStatusAndInformationExtensions();
        status.setType(serviceInfo.getServiceTypeIdentifier());
        status.setStatus(serviceInfo.getServiceStatus());
        status.setServiceSupplyPoints(this.getServiceSupplyPoints(serviceInfo.getServiceSupplyPoints()));
        ExtensionsListType serviceInformationExtensions = serviceInfo.getServiceInformationExtensions();
        if (serviceInformationExtensions != null) {
            status.setConditionsForQualifiers(this.extractConditionsForQualifiers(serviceInformationExtensions.getExtension()));
            status.setAdditionalServiceInfoUris(this.extractAdditionalServiceInfoUris(serviceInformationExtensions.getExtension()));
            status.setExpiredCertsRevocationInfo(this.extractExpiredCertsRevocationInfo(serviceInformationExtensions.getExtension()));
        }
        Date nextEndDate = this.convertToDate(serviceInfo.getStatusStartingTime());
        status.setStartDate(nextEndDate);
        statusHistoryList.addOldest((TimeDependent)status);
        if (tslService.getServiceHistory() != null && Utils.isCollectionNotEmpty((Collection)tslService.getServiceHistory().getServiceHistoryInstance())) {
            for (ServiceHistoryInstanceType serviceHistory : tslService.getServiceHistory().getServiceHistoryInstance()) {
                TSLServiceStatusAndInformationExtensions statusHistory = new TSLServiceStatusAndInformationExtensions();
                statusHistory.setType(serviceHistory.getServiceTypeIdentifier());
                statusHistory.setStatus(serviceHistory.getServiceStatus());
                ExtensionsListType serviceHistoryInformationExtensions = serviceHistory.getServiceInformationExtensions();
                if (serviceHistoryInformationExtensions != null) {
                    statusHistory.setConditionsForQualifiers(this.extractConditionsForQualifiers(serviceHistoryInformationExtensions.getExtension()));
                    statusHistory.setAdditionalServiceInfoUris(this.extractAdditionalServiceInfoUris(serviceHistoryInformationExtensions.getExtension()));
                    statusHistory.setExpiredCertsRevocationInfo(this.extractExpiredCertsRevocationInfo(serviceHistoryInformationExtensions.getExtension()));
                }
                statusHistory.setEndDate(nextEndDate);
                nextEndDate = this.convertToDate(serviceHistory.getStatusStartingTime());
                statusHistory.setStartDate(nextEndDate);
                statusHistoryList.addOldest((TimeDependent)statusHistory);
            }
        }
        return statusHistoryList;
    }

    private List<String> extractAdditionalServiceInfoUris(List<ExtensionType> extensions) {
        ArrayList<String> additionalServiceInfos = new ArrayList<String>();
        for (ExtensionType extensionType : extensions) {
            List content = extensionType.getContent();
            if (!Utils.isCollectionNotEmpty((Collection)content)) continue;
            for (Object object : content) {
                AdditionalServiceInformationType additionalServiceInfo;
                NonEmptyMultiLangURIType uri;
                JAXBElement jaxbElement;
                Object objectValue;
                if (!(object instanceof JAXBElement) || !((objectValue = (jaxbElement = (JAXBElement)object).getValue()) instanceof AdditionalServiceInformationType) || (uri = (additionalServiceInfo = (AdditionalServiceInformationType)objectValue).getURI()) == null || !ENGLISH_LANGUAGE.equals(uri.getLang())) continue;
                additionalServiceInfos.add(uri.getValue());
            }
        }
        return additionalServiceInfos;
    }

    private List<TSLConditionsForQualifiers> extractConditionsForQualifiers(List<ExtensionType> extensions) {
        ArrayList<TSLConditionsForQualifiers> conditionsForQualifiers = new ArrayList<TSLConditionsForQualifiers>();
        for (ExtensionType extensionType : extensions) {
            List content = extensionType.getContent();
            if (!Utils.isCollectionNotEmpty((Collection)content)) continue;
            for (Object object : content) {
                QualificationsType qt;
                JAXBElement jaxbElement;
                Object objectValue;
                if (!(object instanceof JAXBElement) || !((objectValue = (jaxbElement = (JAXBElement)object).getValue()) instanceof QualificationsType) || (qt = (QualificationsType)jaxbElement.getValue()) == null || !Utils.isCollectionNotEmpty((Collection)qt.getQualificationElement())) continue;
                for (QualificationElementType qualificationElement : qt.getQualificationElement()) {
                    List<String> qualifiers = this.extractQualifiers(qualificationElement);
                    Condition condition = this.getCondition(qualificationElement.getCriteriaList());
                    if (!Utils.isCollectionNotEmpty(qualifiers) || condition == null) continue;
                    conditionsForQualifiers.add(new TSLConditionsForQualifiers(qualifiers, condition));
                }
            }
        }
        return conditionsForQualifiers;
    }

    private Date extractExpiredCertsRevocationInfo(List<ExtensionType> extensions) {
        for (ExtensionType extensionType : extensions) {
            List content = extensionType.getContent();
            if (!Utils.isCollectionNotEmpty((Collection)content)) continue;
            for (Object object : content) {
                JAXBElement jaxbElement;
                Object objectValue;
                if (!(object instanceof JAXBElement) || !((objectValue = (jaxbElement = (JAXBElement)object).getValue()) instanceof XMLGregorianCalendar)) continue;
                XMLGregorianCalendar calendar = (XMLGregorianCalendar)objectValue;
                return calendar.toGregorianCalendar().getTime();
            }
        }
        return null;
    }

    private List<String> extractQualifiers(QualificationElementType qualificationElement) {
        ArrayList<String> qualifiers = new ArrayList<String>();
        QualifiersType qualifiersType = qualificationElement.getQualifiers();
        if (qualifiersType != null && Utils.isCollectionNotEmpty((Collection)qualifiersType.getQualifier())) {
            for (QualifierType qualitierType : qualifiersType.getQualifier()) {
                qualifiers.add(qualitierType.getUri());
            }
        }
        return qualifiers;
    }

    protected Condition getCondition(CriteriaListType criteriaList) {
        if (criteriaList == null) {
            return null;
        }
        MatchingCriteriaIndicator matchingCriteriaIndicator = MatchingCriteriaIndicator.valueOf((String)criteriaList.getAssert());
        CompositeCondition condition = new CompositeCondition(matchingCriteriaIndicator);
        this.addKeyUsageConditionsIfPresent(criteriaList.getKeyUsage(), condition);
        this.addPolicyIdConditionsIfPresent(criteriaList.getPolicySet(), condition);
        this.addOtherCriteriaListConditionsIfPresent(criteriaList.getOtherCriteriaList(), condition);
        this.addCriteriaListConditionsIfPresent(criteriaList.getCriteriaList(), condition);
        return condition;
    }

    private void addOtherCriteriaListConditionsIfPresent(eu.europa.esig.jaxb.xades.AnyType otherCriteriaList, CompositeCondition condition) {
        if (otherCriteriaList != null && Utils.isCollectionNotEmpty((Collection)otherCriteriaList.getContent())) {
            for (Object content : otherCriteriaList.getContent()) {
                if (!(content instanceof JAXBElement)) continue;
                JAXBElement jaxbElement = (JAXBElement)content;
                Object objectValue = jaxbElement.getValue();
                if (objectValue instanceof CertSubjectDNAttributeType) {
                    CertSubjectDNAttributeType certSubDNAttr = (CertSubjectDNAttributeType)objectValue;
                    condition.addChild((Condition)new CertSubjectDNAttributeCondition(this.extractOids(certSubDNAttr.getAttributeOID())));
                    continue;
                }
                if (objectValue instanceof ExtendedKeyUsageType) {
                    ExtendedKeyUsageType extendedKeyUsage = (ExtendedKeyUsageType)objectValue;
                    condition.addChild((Condition)new ExtendedKeyUsageCondition(this.extractOids(extendedKeyUsage.getKeyPurposeId())));
                    continue;
                }
                throw new DSSException("Unsupported OtherCriteriaList");
            }
        }
    }

    private List<String> extractOids(List<ObjectIdentifierType> oits) {
        ArrayList<String> oids = new ArrayList<String>();
        if (Utils.isCollectionNotEmpty(oits)) {
            for (ObjectIdentifierType objectIdentifierType : oits) {
                oids.add(objectIdentifierType.getIdentifier().getValue());
            }
        }
        return oids;
    }

    private void addPolicyIdConditionsIfPresent(List<PoliciesListType> policySet, CompositeCondition criteriaCondition) {
        if (Utils.isCollectionNotEmpty(policySet)) {
            for (PoliciesListType policiesListType : policySet) {
                CompositeCondition condition = new CompositeCondition();
                for (ObjectIdentifierType oidType : policiesListType.getPolicyIdentifier()) {
                    IdentifierType identifier = oidType.getIdentifier();
                    String id = identifier.getValue();
                    if (id.indexOf(58) >= 0) {
                        id = id.substring(id.lastIndexOf(58) + 1);
                    }
                    condition.addChild((Condition)new PolicyIdCondition(id));
                }
                criteriaCondition.addChild((Condition)condition);
            }
        }
    }

    private void addKeyUsageConditionsIfPresent(List<KeyUsageType> keyUsages, CompositeCondition criteriaCondition) {
        if (Utils.isCollectionNotEmpty(keyUsages)) {
            for (KeyUsageType keyUsageType : keyUsages) {
                CompositeCondition condition = new CompositeCondition();
                for (KeyUsageBitType keyUsageBit : keyUsageType.getKeyUsageBit()) {
                    condition.addChild((Condition)new KeyUsageCondition(keyUsageBit.getName(), keyUsageBit.isValue()));
                }
                criteriaCondition.addChild((Condition)condition);
            }
        }
    }

    private void addCriteriaListConditionsIfPresent(List<CriteriaListType> criteriaList, CompositeCondition condition) {
        if (Utils.isCollectionNotEmpty(criteriaList)) {
            for (CriteriaListType criteriaListType : criteriaList) {
                condition.addChild(this.getCondition(criteriaListType));
            }
        }
    }

    private String getPostalAddress(TSPInformationType tspInformation) {
        PostalAddressType a = null;
        if (tspInformation.getTSPAddress() == null) {
            return null;
        }
        for (PostalAddressType c : tspInformation.getTSPAddress().getPostalAddresses().getPostalAddress()) {
            if (!ENGLISH_LANGUAGE.equalsIgnoreCase(c.getLang())) continue;
            a = c;
            break;
        }
        if (a == null) {
            a = (PostalAddressType)tspInformation.getTSPAddress().getPostalAddresses().getPostalAddress().get(0);
        }
        StringBuilder sb = new StringBuilder();
        if (Utils.isStringNotEmpty((String)a.getStreetAddress())) {
            sb.append(a.getStreetAddress());
            sb.append(", ");
        }
        if (Utils.isStringNotEmpty((String)a.getPostalCode())) {
            sb.append(a.getPostalCode());
            sb.append(", ");
        }
        if (Utils.isStringNotEmpty((String)a.getLocality())) {
            sb.append(a.getLocality());
            sb.append(", ");
        }
        if (Utils.isStringNotEmpty((String)a.getStateOrProvince())) {
            sb.append(a.getStateOrProvince());
            sb.append(", ");
        }
        if (Utils.isStringNotEmpty((String)a.getCountryName())) {
            sb.append(a.getCountryName());
        }
        return sb.toString();
    }

    private String getElectronicAddress(TSPInformationType tspInformation) {
        if (tspInformation.getTSPAddress().getElectronicAddress() == null) {
            return null;
        }
        return ((NonEmptyMultiLangURIType)tspInformation.getTSPAddress().getElectronicAddress().getURI().get(0)).getValue();
    }

    private String getEnglishOrFirst(InternationalNamesType names) {
        if (names == null) {
            return null;
        }
        for (MultiLangNormStringType s : names.getName()) {
            if (!ENGLISH_LANGUAGE.equalsIgnoreCase(s.getLang())) continue;
            return s.getValue();
        }
        return ((MultiLangNormStringType)names.getName().get(0)).getValue();
    }

    private List<String> getEnglishSchemeInformationURIs(TrustStatusListType tsl) {
        LinkedList<String> result = new LinkedList<String>();
        NonEmptyMultiLangURIListType schemeInformationURI = tsl.getSchemeInformation().getSchemeInformationURI();
        if (schemeInformationURI != null && Utils.isCollectionNotEmpty((Collection)schemeInformationURI.getURI())) {
            for (NonEmptyMultiLangURIType uri : schemeInformationURI.getURI()) {
                if (!ENGLISH_LANGUAGE.equals(uri.getLang())) continue;
                result.add(uri.getValue());
            }
        }
        return result;
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class, eu.europa.esig.jaxb.ecc.ObjectFactory.class, eu.europa.esig.jaxb.tslx.ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new DSSException("Unable to initialize JaxB : " + e.getMessage(), (Throwable)e);
        }
    }
}

