/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.service;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.FileDocument;
import eu.europa.esig.dss.tsl.TSLValidationResult;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CommonCertificateVerifier;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.policy.rules.Indication;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.validation.reports.SimpleReport;
import eu.europa.esig.dss.x509.CertificateSource;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSLValidator
implements Callable<TSLValidationResult> {
    private static final Logger LOG = LoggerFactory.getLogger(TSLValidator.class);
    private File file;
    private String countryCode;
    private List<CertificateToken> potentialSigners;

    public TSLValidator(File file, String countryCode, List<CertificateToken> potentialSigners) {
        this.file = file;
        this.countryCode = countryCode;
        this.potentialSigners = potentialSigners;
    }

    @Override
    public TSLValidationResult call() throws Exception {
        CommonCertificateVerifier certificateVerifier = new CommonCertificateVerifier(true);
        certificateVerifier.setTrustedCertSource((CertificateSource)this.buildTrustedCertificateSource(this.potentialSigners));
        FileDocument dssDocument = new FileDocument(this.file);
        XMLDocumentValidator xmlDocumentValidator = new XMLDocumentValidator((DSSDocument)dssDocument);
        xmlDocumentValidator.setCertificateVerifier((CertificateVerifier)certificateVerifier);
        xmlDocumentValidator.setValidationLevel(ValidationLevel.BASIC_SIGNATURES);
        List xPathQueryHolders = xmlDocumentValidator.getXPathQueryHolder();
        xPathQueryHolders.clear();
        xPathQueryHolders.add(new XPathQueryHolder());
        Reports reports = xmlDocumentValidator.validateDocument(TSLValidator.class.getResourceAsStream("/tsl-constraint.xml"));
        SimpleReport simpleReport = reports.getSimpleReport();
        Indication indication = simpleReport.getIndication(simpleReport.getFirstSignatureId());
        boolean isValid = Indication.TOTAL_PASSED.equals((Object)indication);
        TSLValidationResult result = new TSLValidationResult();
        result.setCountryCode(this.countryCode);
        result.setIndication(indication);
        result.setSubIndication(simpleReport.getSubIndication(simpleReport.getFirstSignatureId()));
        if (!isValid) {
            LOG.info("The TSL signature is not valid : \n");
            reports.print();
        }
        return result;
    }

    private CommonTrustedCertificateSource buildTrustedCertificateSource(List<CertificateToken> potentialSigners) {
        CommonTrustedCertificateSource commonTrustedCertificateSource = new CommonTrustedCertificateSource();
        if (Utils.isCollectionNotEmpty(potentialSigners)) {
            for (CertificateToken potentialSigner : potentialSigners) {
                commonTrustedCertificateSource.addCertificate(potentialSigner);
            }
        }
        return commonTrustedCertificateSource;
    }
}

